/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilIntegerArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotIntArray
implements ISlot,
ISingleSlotTypeFactory {
    private final int[] mValue;

    CSlotIntArray() {
        this.mValue = null;
    }

    private CSlotIntArray(int[] aValue) {
        this.mValue = CUtilIntegerArray.copy(aValue);
    }

    @NotNull
    private static CSlotIntArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof int[]) {
            return new CSlotIntArray((int[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotIntArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotIntArray.fromList((List)aValue);
        }
        return new CSlotIntArray();
    }

    @NotNull
    private static CSlotIntArray fromList(@NotNull List<?> aList) {
        int[] array = CUtilIntegerArray.fromList(aList);
        return new CSlotIntArray(array);
    }

    @NotNull
    private static CSlotIntArray fromStream(@NotNull DataInput aStream) throws IOException {
        int[] array = CUtilIntegerArray.fromStream(aStream);
        return new CSlotIntArray(array);
    }

    @NotNull
    private static CSlotIntArray fromString(@NotNull String aValue) {
        int[] value = CUtilIntegerArray.fromString(aValue);
        return new CSlotIntArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotIntArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            int[] values = new int[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                int j;
                values[i] = j = CUtilInteger.fromObject(child, 0);
                ++i;
            }
            return new CSlotIntArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotIntArray other = (CSlotIntArray)aObj;
        return CUtilIntegerArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return int[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        int[] value = CUtilIntegerArray.copy(this.mValue);
        return new CSlotIntArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.INT_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof int[]) {
            int[] bb = (int[])aValue;
            return CUtilIntegerArray.isEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotIntArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilIntegerArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilIntegerArray.toString(this.mValue, ',', 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilIntegerArray.toString(this.mValue, ',', 0);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (int i : this.mValue) {
                arr.add(i);
            }
            return arr;
        }
        return null;
    }
}

