/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilLong;
import de.sillysky.nyssr.util.CUtilLongArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotLongArray
implements ISlot,
ISingleSlotTypeFactory {
    private final long[] mValue;

    CSlotLongArray() {
        this.mValue = null;
    }

    private CSlotLongArray(long[] aValue) {
        this.mValue = CUtilLongArray.copy(aValue);
    }

    @NotNull
    private static CSlotLongArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof long[]) {
            return new CSlotLongArray((long[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotLongArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotLongArray.fromList((List)aValue);
        }
        return new CSlotLongArray();
    }

    @NotNull
    private static CSlotLongArray fromList(@NotNull List<?> aList) {
        long[] array = CUtilLongArray.fromList(aList);
        return new CSlotLongArray(array);
    }

    @NotNull
    private static CSlotLongArray fromStream(@NotNull DataInput aStream) throws IOException {
        long[] array = CUtilLongArray.fromStream(aStream);
        return new CSlotLongArray(array);
    }

    @NotNull
    private static CSlotLongArray fromString(@NotNull String aValue) {
        long[] array = CUtilLongArray.fromString(aValue);
        return new CSlotLongArray(array);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotLongArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            long[] values = new long[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                values[i] = CUtilLong.fromObject(child, 0L);
                ++i;
            }
            return new CSlotLongArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotLongArray other = (CSlotLongArray)aObj;
        return CUtilLongArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return long[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        long[] value = CUtilLongArray.copy(this.mValue);
        return new CSlotLongArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.LONG_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null) {
            if (aValue instanceof long[]) {
                return CUtilLongArray.isEqual(this.mValue, (long[])aValue);
            }
            if (aValue instanceof Long[]) {
                return CUtilLongArray.isEqual((Long[])aValue, this.mValue);
            }
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotLongArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilLongArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilLongArray.toString(this.mValue, ',', 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilLongArray.toString(this.mValue, ',', 0);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (long i : this.mValue) {
                arr.add(i);
            }
            return arr;
        }
        return null;
    }
}

