/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotObject
implements ISlot,
ISingleSlotTypeFactory {
    private final Object mValue;

    CSlotObject(Object aValue) {
        this.mValue = aValue;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    private static CSlotObject create(Object aValue) {
        return new CSlotObject(aValue);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotObject.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        return null;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Object.class;
    }

    @Override
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.OBJECT;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public boolean isContentEqualTo(Object aValue) {
        if (aValue == null) {
            return this.mValue == null;
        }
        if (this.mValue != null) {
            return this.mValue.equals(aValue);
        }
        return false;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.mValue == null) {
            return "null";
        }
        return this.mValue.toString();
    }

    @Override
    @NotNull
    public String valueToString() {
        return this.toString();
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        throw new UnsupportedOperationException();
    }
}

