/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.util;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.slot.ISlotFactory;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CJsonRecordUtil {
    private static final String ID = "id";
    private static final String SLOTS = "slots";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String KEY = "key";

    private CJsonRecordUtil() {
    }

    @NotNull
    public static CJsonObject toJson(@NotNull CRecord aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        CJsonObject jo = new CJsonObject();
        jo.put(ID, aValue.getId().valueToString());
        CJsonArray slotsArr = new CJsonArray();
        Map<String, ISlot> slots = aValue.getSlots();
        for (Map.Entry<String, ISlot> entry : slots.entrySet()) {
            Object slotValueAsJson;
            ISlot value = entry.getValue();
            if (value == null || (slotValueAsJson = value.toJson(aByteArrayStore)) == null) continue;
            CJsonObject slotJo = new CJsonObject();
            slotJo.put(TYPE, value.getType().getName());
            slotJo.put(KEY, entry.getKey());
            slotJo.put(VALUE, slotValueAsJson);
            slotsArr.add(slotJo);
        }
        if (slotsArr.size() > 0) {
            jo.put(SLOTS, slotsArr);
        }
        return jo;
    }

    @Nullable
    public static CRecord fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore, @NotNull ISlotFactory aSlotFactory) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            Object o = jo.getValue(ID);
            IId id = CIdFactory.fromObject(o);
            if (IId.INVALID.equals(id)) {
                return null;
            }
            CRecord record = new CRecord(id);
            o = jo.getValue(SLOTS);
            if (o instanceof CJsonArray) {
                CJsonArray slotsArr = (CJsonArray)o;
                for (Object child : slotsArr.getChildren()) {
                    ISlot slot;
                    Object o1;
                    CSlotType slotType;
                    String slotTypeName;
                    CJsonObject slotJo;
                    String slotKey;
                    if (!(child instanceof CJsonObject) || !CUtilString.isValid(slotKey = CUtilJsonString.fromJson(slotJo = (CJsonObject)child, KEY, null)) || !CUtilString.isValid(slotTypeName = CUtilJsonString.fromJson(slotJo, TYPE, null)) || (slotType = aSlotFactory.getSlotTypeByName(slotTypeName)) == null || (o1 = slotJo.getValue(VALUE)) == null || (slot = aSlotFactory.fromJson(slotType, o1, aByteArrayStore)) == null) continue;
                    record.addSlot(slotKey, slot);
                }
            }
            return record;
        }
        return null;
    }
}

