/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.kernel.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordAvailable
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("c5c08bf1-bad8-4118-9a26-ffa3b196926d");
    public static final String NAME = "Available";
    public static final String DESCRIPTION = "A service is available.";
    public static final String SLOT_AVAILABLE = "2";
    public static final String SLOT_ID = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getAvailable(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_AVAILABLE);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static IId getId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setAvailable(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_AVAILABLE, slot);
    }

    public static void setId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_ID, slot);
    }
}

