/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log;

import de.sillysky.nyssr.impl.log.CAbstractLogWriter;
import de.sillysky.nyssr.log.CLogDto;
import de.sillysky.nyssr.log.CStartTimeMessageArranger;
import de.sillysky.nyssr.log.ILogWriter;
import de.sillysky.nyssr.log.IMessageArranger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CStartTimeFileLogWriter
extends CAbstractLogWriter
implements ILogWriter {
    private static final String CRLF = System.getProperty("line.separator", "\n");
    private final String mMutex = "";
    private final IMessageArranger mArranger = new CStartTimeMessageArranger();
    private OutputStreamWriter mWriter;

    @Override
    public void start() throws Exception {
        Path path = this.getFilePath().toAbsolutePath();
        File file = path.toFile();
        System.out.println("LogFile: " + file.getPath());
        file.getParentFile().mkdirs();
        FileOutputStream stream = new FileOutputStream(file, this.isFileAppend());
        this.mWriter = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
    }

    @Override
    public void stop() throws Exception {
        if (this.mWriter != null) {
            this.mWriter.close();
            this.mWriter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(@NotNull CLogDto aDto) throws Exception {
        if (this.mWriter == null) return;
        this.getFormatter().format(aDto);
        Collection<String> list = this.mArranger.arrange(aDto);
        String string = "";
        synchronized ("") {
            for (String s : list) {
                this.mWriter.append(s);
                this.mWriter.append(CRLF);
            }
            this.mWriter.flush();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

