/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.target.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordPing
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("73265");
    public static final String NAME = "Ping";
    public static final String DESCRIPTION = "Ping message.";
    public static final String SLOT_LOOP = "1";
    public static final String SLOT_LOOP_MIRROR = "2";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static long getLoop(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LOOP);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static long getLoopMirror(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LOOP_MIRROR);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static void setLoop(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.LONG, aValue);
        aRecord.addSlot(SLOT_LOOP, slot);
    }

    public static void setLoopMirror(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.LONG, aValue);
        aRecord.addSlot(SLOT_LOOP_MIRROR, slot);
    }
}

