/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.util.CLogUtil;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilMath;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CBitField {
    private static final int BITS_PER_BYTE = 8;
    private static final int BITS_PER_LINE = 8;
    private static final int BYTES_PER_ROW = 5;
    private static final int MAX_BYTE = 255;
    private static final int FLIP1 = 3;
    private static final int FLIP2 = 7;
    private byte[] mBytes;
    private int mSize;

    public CBitField() {
        this(8);
    }

    private CBitField(boolean aDummy, byte[] aBytes, int aBitCount) {
        this.mSize = aBitCount;
        this.mBytes = aBytes;
    }

    public CBitField(byte aByte) {
        this.mBytes = new byte[1];
        this.mBytes[0] = aByte;
        this.mSize = 8;
    }

    public CBitField(byte[] aBytes) {
        if (aBytes == null) {
            throw new IllegalArgumentException("Bytes are null");
        }
        this.mSize = aBytes.length * 8;
        int len = aBytes.length;
        this.mBytes = new byte[len];
        System.arraycopy(aBytes, 0, this.mBytes, 0, len);
    }

    public CBitField(byte[] aBytes, int aBitCount) {
        if (aBitCount <= 0) {
            throw new IllegalArgumentException("Bit Count not okay: BitCount=" + aBitCount);
        }
        this.mSize = aBitCount;
        int len = (int)CUtilMath.getBlockCount(aBitCount, 8L);
        this.mBytes = new byte[len];
        if (aBytes != null) {
            System.arraycopy(aBytes, 0, this.mBytes, 0, Math.min(len, aBytes.length));
        }
    }

    public CBitField(int aBitCount) {
        if (aBitCount <= 0) {
            throw new IllegalArgumentException("Bit Count not okay: BitCount=" + aBitCount);
        }
        int bytes = (int)CUtilMath.getBlockCount(aBitCount, 8L);
        this.mBytes = new byte[bytes];
        this.mSize = aBitCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CBitField fromList(List<?> aValue) throws CException {
        if (aValue == null || aValue.isEmpty()) return null;
        int size = aValue.size();
        CBitField bf = new CBitField(size);
        int i = 0;
        for (Object t : aValue) {
            if (t instanceof Boolean) {
                bf.set(i, (Boolean)t);
            } else if (t instanceof String) {
                if ("1".equals(t)) {
                    bf.on(i);
                } else {
                    if (!"0".equals(t)) throw new CException(6).append("Malformed list for creating bit field. List MUST only contain \"0\" or \"1\" strings, or boolean, byte, short, int or long values.");
                    bf.off(i);
                }
            } else if (t instanceof Byte) {
                byte tt = (Byte)t;
                bf.set(i, tt != 0);
            } else if (t instanceof Short) {
                short tt = (Short)t;
                bf.set(i, tt != 0);
            } else if (t instanceof Integer) {
                int tt = (Integer)t;
                bf.set(i, tt != 0);
            } else {
                if (!(t instanceof Long)) throw new CException(6).append("Malformed list for creating bit field. List MUST only contain \"0\" or \"1\" strings, or boolean, byte, short, int or long values.");
                long tt = (Long)t;
                bf.set(i, tt != 0L);
            }
            ++i;
        }
        return bf;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CBitField fromStreamFixedLength(@NotNull DataInput aStream) throws IOException {
        short bitCount = aStream.readShort();
        int arrayLen = (int)CUtilMath.getBlockCount(bitCount, 8L);
        byte[] bb = new byte[arrayLen];
        aStream.readFully(bb);
        return new CBitField(true, bb, bitCount);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CBitField fromStreamVariableLength(@NotNull DataInput aStream) throws IOException {
        int bitCount = CPositiveInteger.fromStream(aStream);
        int arrayLen = (int)CUtilMath.getBlockCount(bitCount, 8L);
        byte[] bb = new byte[arrayLen];
        aStream.readFully(bb);
        return new CBitField(true, bb, bitCount);
    }

    @Nullable
    public static CBitField fromString(@Nullable String aValue) throws CException {
        String[] tokens;
        if (CUtilString.isValid(aValue) && (tokens = aValue.split("-")).length > 0) {
            CBitField bf = new CBitField(tokens.length);
            for (int i = 0; i < tokens.length; ++i) {
                if ("1".equals(tokens[i])) {
                    bf.on(i);
                    continue;
                }
                if ("0".equals(tokens[i])) {
                    bf.off(i);
                    continue;
                }
                throw new CException(6).append("Malformed String for creating bit field. Use something like \"1-0-0-1-1-0-0\"");
            }
            return bf;
        }
        return null;
    }

    public static boolean equals(@Nullable CBitField aBitField1, @Nullable CBitField aBitField2) {
        if (aBitField1 == aBitField2) {
            return true;
        }
        if (aBitField1 != null) {
            return aBitField1.equals(aBitField2);
        }
        return false;
    }

    public static void toStreamFixedLength(@NotNull DataOutput aStream, @Nullable CBitField aBitField) throws IOException {
        if (aBitField == null) {
            aStream.writeByte(0);
        } else {
            aStream.writeShort(aBitField.mSize);
            aStream.write(aBitField.mBytes);
        }
    }

    public static void toStreamVariableLength(@NotNull DataOutput aStream, @Nullable CBitField aBitField) throws IOException {
        if (aBitField == null) {
            aStream.writeByte(0);
        } else {
            CPositiveInteger.toStream(aStream, aBitField.mSize);
            aStream.write(aBitField.mBytes);
        }
    }

    @NotNull
    public static CBitField random(int aSizeInBytes) {
        byte[] bb = CUtilByteArray.random(aSizeInBytes);
        return new CBitField(bb);
    }

    private void check(int aBitIndex) {
        if (aBitIndex < 0 || aBitIndex >= this.mSize) {
            throw new IndexOutOfBoundsException("Index out of range: Index=" + aBitIndex + " Size=" + this.mSize);
        }
    }

    public int countOn() {
        int on = 0;
        for (int i = 0; i < this.mSize; ++i) {
            if (!this.get(i)) continue;
            ++on;
        }
        return on;
    }

    public void dump(@NotNull PrintStream aStream) {
        StringBuilder sb = new StringBuilder(24);
        int inLine = 0;
        for (int i = 0; i < this.mSize; ++i) {
            if (inLine == 0) {
                sb.append(CLogUtil.fixLength(Integer.toString(i), 5, true, ' '));
                sb.append(" [");
            } else {
                sb.append("-");
            }
            sb.append(this.getChecked(i) ? 1 : 0);
            if (inLine == 7) {
                sb.append("]");
                aStream.println(sb);
                sb.delete(0, sb.length());
                inLine = 0;
                continue;
            }
            ++inLine;
        }
        if (inLine != 0) {
            sb.append("]");
            aStream.println(sb);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CBitField)) {
            return false;
        }
        CBitField other = (CBitField)obj;
        if (!Arrays.equals(this.mBytes, other.mBytes)) {
            return false;
        }
        return this.mSize == other.mSize;
    }

    public void flip() {
        int i = 0;
        while (i < this.mBytes.length) {
            int n = i++;
            this.mBytes[n] = (byte)(this.mBytes[n] ^ 0xFF);
        }
    }

    public void flip(int aBitIndex) {
        this.check(aBitIndex);
        int n = aBitIndex >> 3;
        this.mBytes[n] = (byte)(this.mBytes[n] ^ 1 << (aBitIndex & 7));
    }

    public void fromStream(@NotNull DataInput aStream, int aLength) throws IOException {
        this.mBytes = new byte[aLength];
        aStream.readFully(this.mBytes);
        this.mSize = this.mBytes.length * 8;
    }

    public boolean get(int aBitIndex) {
        this.check(aBitIndex);
        return this.getChecked(aBitIndex);
    }

    public int get(int aBitIndexStart, int aLenInBits) {
        this.check(aBitIndexStart);
        this.check(aBitIndexStart + aLenInBits - 1);
        return this.getChecked(aBitIndexStart, aLenInBits);
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    public CBitField getCopy() {
        return new CBitField(this.mBytes, this.mSize);
    }

    public int getPercent() {
        int on = 0;
        int off = 0;
        for (int i = 0; i < this.mSize; ++i) {
            if (this.get(i)) {
                ++on;
                continue;
            }
            ++off;
        }
        return on * 100 / (on + off);
    }

    private boolean getChecked(int aBitIndex) {
        return (this.mBytes[aBitIndex >> 3] & 1 << (aBitIndex & 7)) != 0;
    }

    private int getChecked(int aBitIndexStart, int aLenInBits) {
        int val = 0;
        for (int i = 0; i < aLenInBits; ++i) {
            boolean bit = this.getChecked(aBitIndexStart + aLenInBits - 1 - i);
            if (!bit) continue;
            val |= 1 << i;
        }
        return val;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mBytes);
        result = 31 * result + this.mSize;
        return result;
    }

    void off() {
        int bitsOverAll = this.mBytes.length * 8;
        if (bitsOverAll == this.mSize) {
            Arrays.fill(this.mBytes, (byte)0);
        } else {
            int len = this.mSize / 8;
            Arrays.fill(this.mBytes, 0, len, (byte)0);
            for (int i = len; i < this.mSize; ++i) {
                this.offWithoutCheck(i);
            }
        }
    }

    private void off(int aBitIndex) {
        this.check(aBitIndex);
        this.offWithoutCheck(aBitIndex);
    }

    private void offWithoutCheck(int aBitIndex) {
        int n = aBitIndex >> 3;
        this.mBytes[n] = (byte)(this.mBytes[n] & ~(1 << (aBitIndex & 7)));
    }

    public void on() {
        int bitsOverAll = this.mBytes.length * 8;
        if (bitsOverAll == this.mSize) {
            Arrays.fill(this.mBytes, (byte)-1);
        } else {
            int len = this.mSize / 8;
            Arrays.fill(this.mBytes, 0, len, (byte)-1);
            for (int i = len; i < this.mSize; ++i) {
                this.onWithoutCheck(i);
            }
        }
    }

    public void on(int aBitIndex) {
        this.check(aBitIndex);
        this.onWithoutCheck(aBitIndex);
    }

    private void onWithoutCheck(int aBitIndex) {
        int n = aBitIndex >> 3;
        this.mBytes[n] = (byte)(this.mBytes[n] | 1 << (aBitIndex & 7));
    }

    public void set(int aBitIndex, boolean aOn) {
        this.check(aBitIndex);
        if (aOn) {
            this.on(aBitIndex);
        } else {
            this.off(aBitIndex);
        }
    }

    public void set(int aBitIndexStart, int aLenInBits, int aValue) {
        this.check(aBitIndexStart);
        this.check(aBitIndexStart + aLenInBits - 1);
        for (int i = 0; i < aLenInBits; ++i) {
            this.set(aBitIndexStart + aLenInBits - i - 1, (aValue & 1 << i) > 0);
        }
    }

    public int size() {
        return this.mSize;
    }

    public void toList(List<String> aList) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.getChecked(i)) {
                aList.add("1");
                continue;
            }
            aList.add("0");
        }
    }

    public void toStreamWithoutLength(DataOutput aStream) throws IOException {
        aStream.write(this.mBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("BitField Len=");
        sb.append(this.size());
        sb.append("bits [");
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                sb.append("-");
            }
            sb.append(this.getChecked(i) ? 1 : 0);
        }
        sb.append("]");
        return sb.toString();
    }

    public String valueToString() {
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                sb.append("-");
            }
            sb.append(this.getChecked(i) ? 1 : 0);
        }
        return sb.toString();
    }
}

