/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class CPositiveInteger {
    public static final int LENGTH_1BYTE = 63;
    public static final int LENGTH_2BYTE = 16383;
    public static final int LENGTH_3BYTE = 0x3FFFFF;
    public static final int LENGTH_4BYTE = 0x3FFFFFFF;
    private static final byte BIT_ENCODING = 3;
    private static final int BYTE_MASK = 255;
    private static final int BYTE_MASK2 = 255;
    private static final int BYTE_COUNT_1 = 1;
    private static final int BYTE_COUNT_2 = 2;
    private static final int BYTE_COUNT_3 = 3;
    private static final int SHIFT_8 = 8;
    private static final int SHIFT_16 = 16;
    private static final int SHIFT_24 = 24;
    private static final int SHIFT_6 = 6;
    private static final int SHIFT_14 = 14;
    private static final int SHIFT_22 = 22;

    private CPositiveInteger() {
    }

    public static int fromStream(@NotNull DataInput aStream) throws IOException {
        int byte1 = CPositiveInteger.readUnsignedByte(aStream);
        int byteCount = (byte1 & 3) + 1;
        int result = byte1 >> 2;
        if (byteCount > 1) {
            result += CPositiveInteger.readUnsignedByte(aStream) << 6;
        }
        if (byteCount > 2) {
            result += CPositiveInteger.readUnsignedByte(aStream) << 14;
        }
        if (byteCount > 3) {
            result += CPositiveInteger.readUnsignedByte(aStream) << 22;
        }
        return result;
    }

    private static int getByteCount(int aLength) throws IOException {
        int result = 1;
        if (aLength > 63) {
            ++result;
        }
        if (aLength > 16383) {
            ++result;
        }
        if (aLength > 0x3FFFFF) {
            ++result;
        }
        if (aLength > 0x3FFFFFFF) {
            throw new IOException("Length > 1073741823 not supported.");
        }
        return result;
    }

    private static int readUnsignedByte(@NotNull DataInput aStream) throws IOException {
        return 0xFF & aStream.readByte();
    }

    public static void toStream(@NotNull DataOutput aStream, int aLength) throws IOException {
        if (aLength < 0) {
            throw new IOException("Negative values are not supported.");
        }
        int length = aLength << 2;
        int byteCount = CPositiveInteger.getByteCount(aLength);
        aStream.write((length |= byteCount - 1) & 0xFF);
        if (byteCount > 1) {
            aStream.write(length >> 8 & 0xFF);
        }
        if (byteCount > 2) {
            aStream.write(length >> 16 & 0xFF);
        }
        if (byteCount > 3) {
            aStream.write(length >> 24 & 0xFF);
        }
    }
}

