/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.hash.CHash;
import de.sillysky.nyssr.util.hash.CHashFactory;
import de.sillysky.nyssr.util.hash.EHashType;
import de.sillysky.nyssr.util.hash.IDigest;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

abstract class CAbstractHash
implements IDigest {
    static final String SEPARATOR_STRING = ":";
    private static final char SEPARATOR_CHAR = ':';
    private final EHashType mType;
    private final String mAlgorithm;
    private byte[] mDigest;
    private String mCachedString = null;

    CAbstractHash(EHashType aType, byte[] aDigest, String aAlgorithm) {
        this.mType = aType;
        this.mDigest = aDigest;
        this.mAlgorithm = aAlgorithm;
    }

    @Override
    public IDigest copy() {
        return CHashFactory.fromByteArray(this.mType, this.mDigest);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CAbstractHash)) {
            return false;
        }
        CHash other = (CHash)obj;
        if (this.mAlgorithm == null ? other.mAlgorithm != null : !this.mAlgorithm.equals(other.mAlgorithm)) {
            return false;
        }
        return Arrays.equals(this.mDigest, other.mDigest);
    }

    @Override
    public String getAlgorithm() {
        return this.mAlgorithm;
    }

    @Override
    public byte[] getByteArray() {
        return this.mDigest;
    }

    public byte[] getHash() {
        return (byte[])this.mDigest.clone();
    }

    @Override
    public EHashType getHashType() {
        return this.mType;
    }

    @Override
    public int getStreamedLength() {
        if (this.mDigest == null) {
            return 1;
        }
        return 3 + this.mDigest.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mAlgorithm == null ? 0 : this.mAlgorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.mDigest);
        return result;
    }

    void storeDigest(byte[] aDigest) {
        this.mDigest = aDigest;
        this.mCachedString = null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        if (this.mDigest == null) {
            aStream.writeByte(EHashType.EMPTY.getValue());
        } else {
            aStream.writeByte(this.mType.getValue());
            aStream.writeShort(this.mDigest.length);
            aStream.write(this.mDigest);
        }
    }

    public String toString() {
        if (this.mDigest == null) {
            return "null";
        }
        if (this.mCachedString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getAlgorithm());
            sb.append(':');
            String bytes = CUtilByteArray.toString(this.mDigest, '\u0000', 0);
            sb.append(bytes);
            this.mCachedString = sb.toString();
        }
        return this.mCachedString;
    }
}

