/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.properties.hierarchical;

import java.util.Arrays;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHierarchicalPropertyKey {
    public static final String DELIMITER = ".";
    private static final String SPLIT = "/.";
    private final LinkedList<String> mKeys = new LinkedList();

    public CHierarchicalPropertyKey() {
    }

    public CHierarchicalPropertyKey(@NotNull String aKey) {
        String[] keys = aKey.split(SPLIT);
        this.mKeys.addAll(Arrays.asList(keys));
    }

    public CHierarchicalPropertyKey(@NotNull String[] aKeys) {
        this.mKeys.addAll(Arrays.asList(aKeys));
    }

    public CHierarchicalPropertyKey(@NotNull CHierarchicalPropertyKey aKey) {
        this.mKeys.addAll(aKey.mKeys);
    }

    public CHierarchicalPropertyKey add(@NotNull String aKey) {
        this.mKeys.addLast(aKey);
        return this;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CHierarchicalPropertyKey that = (CHierarchicalPropertyKey)aO;
        return this.mKeys.equals(that.mKeys);
    }

    CHierarchicalPropertyKey getClone() {
        return new CHierarchicalPropertyKey(this);
    }

    public int hashCode() {
        return this.mKeys.hashCode();
    }

    public boolean isEmpty() {
        return this.mKeys.isEmpty();
    }

    @Nullable
    public String removeFirst() {
        if (this.mKeys.isEmpty()) {
            return null;
        }
        return this.mKeys.removeFirst();
    }

    @Nullable
    private CHierarchicalPropertyKey shorten() {
        if (this.mKeys.isEmpty()) {
            return null;
        }
        CHierarchicalPropertyKey key = new CHierarchicalPropertyKey(this);
        key.shorten();
        return key;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : this.mKeys) {
            if (first) {
                first = false;
            } else {
                sb.append(DELIMITER);
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

