/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.stringrecord;

import de.sillysky.nyssr.util.stringrecord.CStringRecord;
import java.util.ArrayList;
import java.util.List;

public final class CStringRecordHelper {
    public static final char CHAR_RECORD_DELIMITER = '=';
    public static final char CHAR_RECORD_END = '}';
    public static final char CHAR_RECORD_START = '{';
    public static final char ESCAPE_CHAR_END = '\\';
    public static final String ESCAPED_CHAR_END = "\\}";
    public static final String UNESCAPED_CHAR_END = "}";
    private final List<CStringRecord> mRecords = new ArrayList<CStringRecord>();

    public void add(String aKey, String aValue) {
        this.mRecords.add(new CStringRecord(aKey, aValue));
    }

    private void addToList(String aStr) {
        int i;
        String s;
        if (aStr != null && !(s = aStr.trim()).isEmpty() && (i = s.indexOf(61)) > 0) {
            CStringRecord r = new CStringRecord(aStr);
            this.mRecords.add(r);
        }
    }

    public String getRecordString() {
        StringBuilder sb = new StringBuilder(200);
        for (CStringRecord r : this.mRecords) {
            sb.append(r.getRecordString());
        }
        return sb.toString();
    }

    public List<CStringRecord> getRecords() {
        return this.mRecords;
    }

    public void split(String aSrc) {
        StringBuilder sb = new StringBuilder(100);
        boolean in = false;
        boolean escape = false;
        for (int i = 0; i < aSrc.length(); ++i) {
            char c = aSrc.charAt(i);
            if (escape) {
                if (in) {
                    sb.append('\\');
                    sb.append(c);
                }
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (!in) {
                if (c != '{') continue;
                in = true;
                continue;
            }
            if (c == '}') {
                in = false;
                this.addToList(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        this.addToList(sb.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        for (CStringRecord r : this.mRecords) {
            sb.append(r.toString());
            sb.append(' ');
        }
        return sb.toString();
    }
}

