/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.time;

import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilLong;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilInstant {
    private CUtilInstant() {
    }

    @Nullable
    public static Instant fromStream(@NotNull DataInput aStream) throws IOException {
        Instant result;
        boolean notNull = aStream.readBoolean();
        if (notNull) {
            long seconds = aStream.readLong();
            int nanos = aStream.readInt();
            result = Instant.ofEpochSecond(seconds, nanos);
        } else {
            result = null;
        }
        return result;
    }

    @NotNull
    public static String valueToString(@Nullable Instant aValue) {
        if (aValue == null) {
            return "";
        }
        return String.format("%d:%d", aValue.getEpochSecond(), aValue.getNano());
    }

    @NotNull
    public static String valueToIsoString(@Nullable Instant aValue) {
        if (aValue == null) {
            return "";
        }
        DateTimeFormatter dtf = DateTimeFormatter.ISO_INSTANT;
        return dtf.format(aValue);
    }

    @NotNull
    public static Instant fromIsoString(@Nullable String aValue) {
        if (CUtilString.isEmpty(aValue)) {
            return Instant.MIN;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ISO_INSTANT;
        TemporalAccessor ta = dtf.parse(aValue);
        return Instant.from(ta);
    }

    @Nullable
    public static Instant fromString(@Nullable String aString) {
        String[] split;
        Instant result = null;
        if (CUtilString.isValid(aString) && (split = aString.split(":")).length == 2) {
            long seconds = CUtilLong.fromObject(split[0], 0L);
            int nanos = CUtilInteger.fromObject(split[1], 0);
            result = Instant.ofEpochSecond(seconds, nanos);
        }
        return result;
    }

    @Nullable
    public static Instant fromUtcString(@Nullable String aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return null;
        }
        LocalDateTime odt = LocalDateTime.parse(aValue);
        return odt.toInstant(ZoneOffset.UTC);
    }

    @Nullable
    public static Instant fromLocalDateTime(@Nullable LocalDateTime aValue) {
        Instant result = null;
        if (aValue != null) {
            result = aValue.atZone(ZoneId.systemDefault()).toInstant();
        }
        return result;
    }

    @Nullable
    public static Instant fromLocalDateTimeUtc(@Nullable LocalDateTime aValue) {
        Instant result = null;
        if (aValue != null) {
            result = aValue.atZone(ZoneOffset.UTC).toInstant();
        }
        return result;
    }

    @Nullable
    public static Instant fromFileTime(@Nullable FileTime aValue) {
        Instant result = null;
        if (aValue != null) {
            result = aValue.toInstant();
        }
        return result;
    }

    @Nullable
    public static Instant fromLocalDate(@Nullable LocalDate aValue) {
        Instant result = null;
        if (aValue != null) {
            result = aValue.atStartOfDay(ZoneId.systemDefault()).toInstant();
        }
        return result;
    }

    @Nullable
    public static Instant fromObject(@Nullable Object aValue) {
        Instant result = aValue instanceof Instant ? (Instant)aValue : (aValue instanceof LocalDate ? CUtilInstant.fromLocalDate((LocalDate)aValue) : (aValue instanceof LocalDateTime ? CUtilInstant.fromLocalDateTime((LocalDateTime)aValue) : (aValue instanceof FileTime ? CUtilInstant.fromFileTime((FileTime)aValue) : (aValue instanceof String ? CUtilInstant.fromString((String)aValue) : null))));
        return result;
    }

    @NotNull
    public static String valueToUtcString(@Nullable Instant aInstant) {
        if (aInstant == null) {
            return "";
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(aInstant, ZoneOffset.UTC);
        return ldt.toString();
    }

    @Nullable
    public static Instant fromSeconds(long aSec, int aNano) {
        if (aSec == 0L && aNano == 0) {
            return null;
        }
        return Instant.ofEpochSecond(aSec, aNano);
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable Instant aValue) throws IOException {
        if (aValue == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            aStream.writeLong(aValue.getEpochSecond());
            aStream.writeInt(aValue.getNano());
        }
    }

    @NotNull
    public static Instant random() {
        Instant now = Instant.now();
        int sec = CUtilRandom.getRandom().nextInt(2000000);
        return now.minusSeconds(sec);
    }

    @NotNull
    public static Instant fromTimestamp(@NotNull Timestamp aValue) {
        return aValue.toInstant();
    }

    @Contract(pure=true)
    @NotNull
    public static @NotNull Instant @NotNull [] randomArray(int aSize, boolean aWithNullValues) {
        Instant[] arr = new Instant[aSize];
        for (int i = 0; i < aSize; ++i) {
            boolean b = CUtilRandom.getRandom().nextBoolean();
            if (!b && aWithNullValues) continue;
            arr[i] = CUtilInstant.random();
        }
        return arr;
    }
}

