/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.client.node.ui.choose;

import de.sillysky.nyssr.impl.client.node.ui.CAppEntry;
import de.sillysky.nyssr.impl.client.node.ui.CUtilUi;
import de.sillysky.nyssr.impl.client.node.ui.INodeClient;
import de.sillysky.nyssr.util.swing.CUtilSwing;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFrameAppChooser2
extends JFrame {
    private static final long serialVersionUID = 7004420363598623634L;
    private final Map<KeyStroke, Action> actionMap = new HashMap<KeyStroke, Action>();
    private final INodeClient mNodeClient;
    private final List<CAppEntry> mApps;
    private final boolean mDebug = false;
    private CAppEntry mAppChosen = null;
    private JList<String> mList;
    private JLabel mLabelIcon;
    private JLabel mLabelName;
    private JLabel mLabelDescription;

    public CFrameAppChooser2(@NotNull INodeClient aNodeClient, @NotNull List<CAppEntry> aApps) {
        super("Start your App!");
        this.mNodeClient = aNodeClient;
        this.mApps = aApps;
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
        this.setupKeys();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        CUtilUi.setImage(this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout("insets 15lp, fill, gap 10lp, wrap 3", "[40mm]5mm[20mm!]5mm[80mm]", "[20mm!,align bottom][fill][8mm!]"));
        contentPane.setBackground(CNamedColors.get((String)"Silver").getColor(255));
        this.addList(contentPane);
        this.addLabelIcon(contentPane);
        this.addLabelName(contentPane);
        this.addLabelDescription(contentPane);
        this.addButtonStart(contentPane);
        this.mList.setSelectedIndex(0);
        this.setLocationRelativeTo(null);
        this.pack();
        this.setAlwaysOnTop(true);
    }

    private void addLabelName(@NotNull Container aContentPane) {
        this.mLabelName = new JLabel("");
        this.mLabelName.setVerticalAlignment(3);
        Font font = this.mLabelName.getFont();
        this.mLabelName.setFont(new Font(font.getFamily(), font.getStyle(), 20));
        aContentPane.add((Component)this.mLabelName, "growX");
    }

    private void addLabelDescription(@NotNull Container aContentPane) {
        this.mLabelDescription = new JLabel("");
        aContentPane.add((Component)this.mLabelDescription, "grow, span 2");
    }

    private void addButtonStart(@NotNull Container aContentPane) {
        JButton start = new JButton("Start");
        aContentPane.add((Component)start, "tag ok, span 2");
        start.addActionListener(e -> {
            if (this.mAppChosen != null) {
                this.mNodeClient.startApp(this.mAppChosen);
            }
        });
        JRootPane rootPane = SwingUtilities.getRootPane(start);
        if (rootPane != null) {
            rootPane.setDefaultButton(start);
        }
    }

    private void addLabelIcon(@NotNull Container aContentPane) {
        this.mLabelIcon = new JLabel();
        aContentPane.add(this.mLabelIcon);
    }

    private void addList(@NotNull Container aContentPane) {
        this.mList = new JList();
        JScrollPane scroll = new JScrollPane(this.mList);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        boolean i = false;
        for (CAppEntry e2 : this.mApps) {
            listModel.add(0, e2.getApplicationName());
        }
        this.mList.setModel(listModel);
        this.mList.setSelectionMode(0);
        this.mList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                String selectedValue = this.mList.getSelectedValue();
                this.mAppChosen = this.findApp(selectedValue);
                if (this.mAppChosen != null) {
                    this.mLabelIcon.setIcon(this.mAppChosen.getImageIcon());
                    this.mLabelName.setText(this.mAppChosen.getApplicationName());
                    this.mLabelDescription.setText(this.mAppChosen.getLongDescription());
                    this.revalidate();
                }
            }
        });
        aContentPane.add((Component)scroll, "grow,span 1 3");
        this.addListAction();
    }

    private void addListAction() {
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CAppEntry entry;
                    String item;
                    Point p = e.getPoint();
                    int index = CFrameAppChooser2.this.mList.locationToIndex(p);
                    if (index >= 0 && (item = (String)CFrameAppChooser2.this.mList.getModel().getElementAt(index)) != null && (entry = CFrameAppChooser2.this.findApp(item)) != null) {
                        CFrameAppChooser2.this.mNodeClient.startApp(entry);
                    }
                }
                super.mouseClicked(e);
            }
        });
    }

    @Nullable
    private CAppEntry findApp(@NotNull String aSelectedItem) {
        for (CAppEntry app : this.mApps) {
            if (!app.getApplicationName().equals(aSelectedItem)) continue;
            return app;
        }
        return null;
    }

    public void setupKeys() {
        KeyStroke key1 = KeyStroke.getKeyStroke(123, 0);
        AbstractAction showDialog = new AbstractAction("showDialog"){
            private static final long serialVersionUID = -4246817212497841846L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CFrameAppChooser2.this.setState(CFrameAppChooser2.this.getState() == 1 ? 0 : 1);
            }
        };
        this.actionMap.put(key1, showDialog);
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(e -> {
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            if (this.actionMap.containsKey(keyStroke)) {
                Action a = this.actionMap.get(keyStroke);
                ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), null);
                CUtilSwing.executeInUiThread(() -> a.actionPerformed(ae));
                return true;
            }
            return false;
        });
    }

    public void updateIfCurrentDisplayedAppEntry(@NotNull CAppEntry aAppEntry) {
        if (aAppEntry.equals(this.mAppChosen)) {
            this.mLabelIcon.setIcon(this.mAppChosen.getImageIcon());
            this.mLabelIcon.repaint();
        }
    }
}

