/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.client.node.ui.main;

import de.sillysky.nyssr.impl.client.node.ui.CAppEntry;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import de.sillysky.nyssr.util.swing.color.CUtilColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class AppEntryRenderer
extends JPanel
implements ListCellRenderer<CAppEntry> {
    private static final long serialVersionUID = -8935831738051887722L;
    private static final Border LINE_BORDER = BorderFactory.createLineBorder(CNamedColors.get((String)"Gold").getColor(60), 2);
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private static final Color BACKGROUND = CUtilColor.fromHex((String)"#00b33c", (int)255);
    private static final Color FOREGROUND = Color.WHITE;
    private static Font mFont;
    private final boolean mDebug = false;

    @Override
    public Component getListCellRendererComponent(JList<? extends CAppEntry> aList, CAppEntry aValue, int aIndex, boolean aIsSelected, boolean aCellHasFocus) {
        JPanel p0 = new JPanel();
        p0.setBackground(BACKGROUND);
        p0.setLayout((LayoutManager)new MigLayout("insets 10,fill"));
        JPanel p1 = new JPanel();
        p1.setBackground(BACKGROUND);
        p1.setBorder(EMPTY_BORDER);
        MigLayout l = new MigLayout("gap 10, insets 10, fill");
        p1.setLayout((LayoutManager)l);
        this.addIcon(aValue, p1);
        this.addHeader(aValue, p1);
        this.addDescription(aValue, p1);
        if (aIsSelected) {
            p1.setBorder(LINE_BORDER);
        } else {
            p1.setBorder(null);
        }
        p0.add(p1);
        return p0;
    }

    private void addIcon(CAppEntry aValue, JPanel aPanel) {
        ImageIcon icon = aValue.getImageIcon();
        JLabel label = new JLabel(icon);
        aPanel.add((Component)label, "span 1 2");
    }

    private void addHeader(CAppEntry aValue, JPanel aPanel) {
        JLabel label = new JLabel(aValue.getApplicationName());
        this.initFont(label);
        label.setFont(mFont);
        label.setForeground(FOREGROUND);
        aPanel.add((Component)label, "wrap,grow 0");
    }

    private void addDescription(CAppEntry aValue, JPanel aPanel) {
        JTextArea area = new JTextArea(aValue.getShortDescription(), 50, 200);
        area.setEditable(false);
        area.setForeground(FOREGROUND);
        area.setBackground(BACKGROUND);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        aPanel.add((Component)area, "height 20px:80px:100px");
    }

    private void initFont(JLabel aLabel) {
        if (mFont == null) {
            Font font1 = aLabel.getFont();
            mFont = new Font(font1.getName(), font1.getStyle(), (int)((float)font1.getSize() * 1.4f));
        }
    }
}

