/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.editpreferences;

import de.sillysky.nyssr.impl.web.dialog.editpreferences.CPreferenceNode;
import de.sillysky.nyssr.impl.web.dialog.editpreferences.IPreferenceItem;
import de.sillysky.nyssr.util.hash.CUtilMd5;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CPreferenceTree {
    private static final String ID_PREFIX_FOR_NODE = "node_";
    private static final String ID_PREFIX_FOR_KEY = "key_";
    private final Map<String, IPreferenceItem> mIds = new HashMap<String, IPreferenceItem>();
    private final CPreferenceNode mRoot;

    public CPreferenceTree(@NotNull CPreferenceNode aRoot) {
        this.mRoot = aRoot;
        this.mIds.put(aRoot.getId(), aRoot);
    }

    CPreferenceNode getRoot() {
        return this.mRoot;
    }

    void addNode(@NotNull IPreferenceItem aItem) {
        this.mIds.put(aItem.getId(), aItem);
    }

    IPreferenceItem getById(String aId) {
        return this.mIds.get(aId);
    }

    CPreferenceNode getPreferenceNode(@NotNull String aPath) {
        String path = aPath.startsWith("/") ? aPath.substring(1) : aPath;
        String[] segments = path.split("/");
        CPreferenceNode node = this.mRoot;
        for (String segment : segments) {
            node = node.getChild(segment);
        }
        return node;
    }

    @NotNull
    static String createNodeId(@NotNull String aPath) {
        return CUtilMd5.encodeToHtmlId((String)(ID_PREFIX_FOR_NODE + aPath));
    }

    @NotNull
    static String createKeyValueId(@NotNull String aPath) {
        return CUtilMd5.encodeToHtmlId((String)(ID_PREFIX_FOR_KEY + aPath));
    }
}

