/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.factory.collector.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordApplication
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"5a8d5a3f-37c0-47f5-bb88-25f5f5e6a20c");
    public static final String NAME = "Application";
    public static final String DESCRIPTION = "The application data.";
    public static final String SLOT_ICON = "iconPath";
    public static final String SLOT_ID = "appId";
    public static final String SLOT_LONG_DESCRIPTION = "longAppDesc";
    public static final String SLOT_NAME = "appName";
    public static final String SLOT_PERMISSIONS = "permissions";
    public static final String SLOT_PLATFORM = "platform";
    public static final String SLOT_PROPERTIES = "properties";
    public static final String SLOT_SHORT_DESCRIPTION = "shortAppDesc";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getIcon(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ICON);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static UUID getId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static String getLongDescription(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LONG_DESCRIPTION);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String[] getPermissions(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PERMISSIONS);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String getPlatform(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PLATFORM);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CStringProperties getProperties(@NotNull CRecord aRecord, CStringProperties aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PROPERTIES);
        if (slot == null) {
            return aDefault;
        }
        return (CStringProperties)slot.getValue();
    }

    public static String getShortDescription(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SHORT_DESCRIPTION);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setIcon(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_ICON, slot);
    }

    public static void setId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_ID, slot);
    }

    public static void setLongDescription(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_LONG_DESCRIPTION, slot);
    }

    public static void setName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_NAME, slot);
    }

    public static void setPermissions(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_PERMISSIONS, slot);
    }

    public static void setPlatform(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PLATFORM, slot);
    }

    public static void setProperties(@NotNull CRecord aRecord, CStringProperties aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_PROPERTIES, (Object)aValue);
        aRecord.addSlot(SLOT_PROPERTIES, slot);
    }

    public static void setShortDescription(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_SHORT_DESCRIPTION, slot);
    }
}

