/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.getfile;

import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CPendingGetFileRequest {
    private final String mPath;
    private final String mHash;
    private final Set<CMessage> mMessages = new HashSet<CMessage>();

    CPendingGetFileRequest(@Nullable String aHash, @Nullable String aPath) {
        this.mHash = aHash;
        this.mPath = aPath;
    }

    public void addMessage(@NotNull CMessage aMessage) {
        this.mMessages.add(aMessage);
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || this.getClass() != aObject.getClass()) {
            return false;
        }
        CPendingGetFileRequest that = (CPendingGetFileRequest)aObject;
        if (!Objects.equals(this.mPath, that.mPath)) {
            return false;
        }
        return Objects.equals(this.mHash, that.mHash);
    }

    public int hashCode() {
        int result = this.mPath != null ? this.mPath.hashCode() : 0;
        result = 31 * result + (this.mHash != null ? this.mHash.hashCode() : 0);
        return result;
    }

    @Nullable
    public String getPath() {
        return this.mPath;
    }

    @Nullable
    public String getHash() {
        return this.mPath;
    }

    public Collection<CMessage> getMessages() {
        return this.mMessages;
    }

    public boolean match(@Nullable String aHash, @Nullable String aPath) {
        if (CUtilString.isValid((String)this.mHash) && this.mHash.equals(aHash)) {
            return true;
        }
        return this.mPath != null && this.mPath.equals(aPath);
    }
}

