/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordFileStoreGetChunk
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"60ff0699-bca8-400b-a997-7a1bbb8724c9");
    public static final String NAME = "FileStoreGetChunk";
    public static final String DESCRIPTION = "Get a file chunk from a network file store.";
    public static final String SLOT_BYTES = "bytes";
    public static final String SLOT_CHUNK_LENGTH = "len";
    public static final String SLOT_CHUNK_POSITION = "pos";
    public static final String SLOT_HASH = "hash";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static byte[] getBytes(@NotNull CRecord aRecord, byte[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_BYTES);
        if (slot == null) {
            return aDefault;
        }
        return (byte[])slot.getValue();
    }

    public static int getChunkLength(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CHUNK_LENGTH);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static long getChunkPosition(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CHUNK_POSITION);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static String getHash(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_HASH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setBytes(@NotNull CRecord aRecord, byte[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BYTE_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_BYTES, slot);
    }

    public static void setChunkLength(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_CHUNK_LENGTH, slot);
    }

    public static void setChunkPosition(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.LONG, (Object)aValue);
        aRecord.addSlot(SLOT_CHUNK_POSITION, slot);
    }

    public static void setHash(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_HASH, slot);
    }
}

