/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.impl.software.updater.local.CSerialJobMachine;
import de.sillysky.nyssr.impl.software.updater.local.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.job.serial.ISerialJobQueueEntry;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

class CJobChangeConfiguration
implements ISerialJobQueueEntry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CJobChangeConfiguration.class);
    private static final String KEY_PREFERENCES = "plugin.manager/plugins";
    private static final String KEY_CONFIG_FILE = "configuration.file.plugin.manager/plugins";
    private final IDependencies mDependencies;
    private final CSerialJobMachine mParent;
    @NotNull
    private final String[] mPluginToLoadList;

    CJobChangeConfiguration(@NotNull IDependencies aDependencies, @NotNull CSerialJobMachine aParent, @NotNull String[] aPluginToLoadList) {
        this.mDependencies = aDependencies;
        this.mParent = aParent;
        this.mPluginToLoadList = aPluginToLoadList;
    }

    @NotNull
    public String getId() {
        return "ChangeConfiguration";
    }

    public void stop() {
    }

    public void start() {
        this.writeConfiguration();
    }

    private void writeConfiguration() {
        if (CUtilStringArray.isEmpty((String[])this.mPluginToLoadList)) {
            this.mParent.jobFinished(this);
        }
        try {
            List<String> list = Arrays.asList(this.mPluginToLoadList);
            this.writeNewConfiguration(list);
            this.removePluginConfigFile();
            this.mParent.jobFinished(this);
        }
        catch (BackingStoreException aException) {
            this.mParent.finish(2, aException.getMessage());
        }
    }

    private void writeNewConfiguration(@NotNull List<String> aPlugins) throws BackingStoreException {
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Preferences p = kc.getPreferences(KEY_PREFERENCES);
        p.clear();
        int i = 0;
        for (String plugin : aPlugins) {
            String s = String.format("%04d", i * 10);
            p.put(s, plugin);
            ++i;
        }
    }

    private void removePluginConfigFile() {
        boolean deleted;
        Path path;
        File file;
        String pathString = this.mDependencies.getNodeStringProperties().get(KEY_CONFIG_FILE);
        if (pathString != null && (file = (path = Paths.get(pathString, new String[0])).toFile()).exists() && !(deleted = file.delete())) {
            LOG.error("Couldn't remove file {}", new Object[]{path.toString()});
        }
    }
}

