/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilToolset {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilToolset.class);

    private CUtilToolset() {
    }

    public static Rectangle getScreenBoundsFor(Rectangle rc) {
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        ArrayList<GraphicsConfiguration> configs = new ArrayList<GraphicsConfiguration>();
        for (GraphicsDevice gd : gds) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            if (!rc.intersects(gc.getBounds())) continue;
            configs.add(gc);
        }
        GraphicsConfiguration selected = null;
        if (configs.size() > 0) {
            for (GraphicsConfiguration gcc : configs) {
                if (selected == null) {
                    selected = gcc;
                    continue;
                }
                if (!gcc.getBounds().contains(rc.x + 20, rc.y + 20)) continue;
                selected = gcc;
                break;
            }
        } else {
            selected = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        int x = selected.getBounds().x;
        int y = selected.getBounds().y;
        int w = selected.getBounds().width;
        int h = selected.getBounds().height;
        return new Rectangle(x, y, w, h);
    }

    @Nullable
    public static Rectangle getEffectiveScreenSize(@NotNull Component aComponent) {
        GraphicsConfiguration gc = aComponent.getGraphicsConfiguration();
        if (gc == null) {
            LOG.error("getEffectiveScreenSize: no graphic configuration available");
            return null;
        }
        return CUtilToolset.getEffectiveScreenSize(gc);
    }

    @Nullable
    public static Rectangle getEffectiveScreenSize(@NotNull GraphicsConfiguration aGC) {
        Rectangle bounds = aGC.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(aGC);
        Rectangle effectiveScreenArea = new Rectangle();
        effectiveScreenArea.x = bounds.x + screenInsets.left;
        effectiveScreenArea.y = bounds.y + screenInsets.top;
        effectiveScreenArea.height = bounds.height - screenInsets.top - screenInsets.bottom;
        effectiveScreenArea.width = bounds.width - screenInsets.left - screenInsets.right;
        return effectiveScreenArea;
    }
}

