/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingAbstractButton;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingButton
extends CSwingAbstractButton {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingButton.class);
    private final JButton mComponent = new JButton();
    private boolean mDefaultButton = false;

    CSwingButton(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("defaultButton", this::applyDefaultButton);
        list.addHandler("defaultCapable", this::applyDefaultCapable);
    }

    private boolean applyDefaultButton(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mDefaultButton = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyDefaultCapable(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean value = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, value});
            this.getComponent().setDefaultCapable(value);
            return true;
        }
        return false;
    }

    @Override
    public void notifyWidget(@NotNull ENotification aNotification, Object ... aObjects) {
        if (ENotification.GOT_PARENT.equals((Object)aNotification)) {
            this.setDefaultButton();
        }
    }

    private void setDefaultButton() {
        JButton button;
        JRootPane rootPane;
        if (this.mDefaultButton && (rootPane = SwingUtilities.getRootPane(button = this.getComponent())) != null) {
            rootPane.setDefaultButton(button);
        }
    }

    @NotNull
    public JButton getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Button.name();
    }
}

