/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.enums.EWidgetOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetOrientation;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingMenuSeparator
extends CSwingJComponent {
    private JSeparator mComponent;

    CSwingMenuSeparator(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        this.addHandler();
    }

    CSwingMenuSeparator(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        this.mComponent = new JSeparator();
        this.addHandler();
    }

    private void addHandler() {
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("orientation", this::applyOrientation);
    }

    private boolean applyOrientation(@NotNull String aKey, @Nullable Object aValue) {
        CEventWidgetOrientation event = CEventWidgetOrientation.create((Object)aValue);
        if (event != null) {
            EWidgetOrientation orientation = event.getOrientation();
            if (orientation == EWidgetOrientation.horizontal) {
                this.mComponent.setOrientation(0);
            } else {
                this.mComponent.setOrientation(1);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public JSeparator getComponent() {
        return this.mComponent;
    }

    public void setComponent(@NotNull JSeparator aSeparator) {
        this.mComponent = aSeparator;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.MenuSeparator.name();
    }
}

