/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingTextField;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventPasswordNotification;
import de.sillysky.nyssr.util.hash.CUtilPassword;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class CSwingPasswordField
extends CSwingTextField {
    private final JPasswordField mComponent = new JPasswordField();
    private String mHash = "";

    CSwingPasswordField(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId, aAttributes);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.mComponent.addActionListener(aEvent -> this.check());
        this.mComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                CSwingPasswordField.this.check();
            }
        });
    }

    private void check() {
        char[] pw = this.mComponent.getPassword();
        String hash = CUtilPassword.hashPassword((char[])pw);
        if (!this.mHash.equals(hash)) {
            this.mHash = hash;
            CEventPasswordNotification event = new CEventPasswordNotification(this.mHash, "SHA384");
            this.addNotification("password", event.toJson());
            this.sendNotification();
        }
    }

    @Override
    @NotNull
    public JTextField getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.PasswordField.name();
    }
}

