/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableHeaderCellRenderer;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableHeaderEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableHeader;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTableHeader
extends JTableHeader {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTableHeader.class);
    private static final long serialVersionUID = -6076570036496138923L;
    private final CTable mTable;

    CTableHeader(@NotNull CTable aTable) {
        super(aTable.getColumnModel());
        this.mTable = aTable;
        this.setDefaultRenderer(new CTableHeaderCellRenderer(this.mTable));
        this.mTable.setDefaultRenderer(String.class, new CTableHeaderCellRenderer(this.mTable));
    }

    @Nullable
    CTableHeaderEntry getHeader(int aColumnIndex) {
        CColumn column = this.mTable.getMyModel().getColumnModel().getColumnByIndex(aColumnIndex);
        if (column != null) {
            return column.getHeader();
        }
        return null;
    }

    @Nullable
    CTableHeaderEntry getHeader(String aColumnId) {
        CColumn column = this.mTable.getMyModel().getColumnModel().getColumn(aColumnId);
        if (column != null) {
            return column.getHeader();
        }
        return null;
    }

    @NotNull
    CTableHeaderEntry getHeaderForced(String aColumnId) {
        CColumn column = this.mTable.getMyModel().getColumnModel().getOrAddColumn(aColumnId);
        return column.getHeader();
    }

    @Nullable
    CTableHeaderEntry getHeaderOrNull(int aColumnIndex) {
        return this.getHeader(aColumnIndex);
    }

    @Override
    public String getToolTipText(MouseEvent aEvent) {
        int col = this.columnAtPoint(aEvent.getPoint());
        int modelCol = this.getTable().convertColumnIndexToModel(col);
        CTableHeaderEntry header = this.getHeader(modelCol);
        if (header != null) {
            return header.getToolTip();
        }
        return null;
    }

    void setHeader(@NotNull CEventTableHeader aEvent) {
        String columnId = aEvent.getColumnId();
        CTableHeaderEntry header = this.getHeaderForced(columnId);
        header.apply(aEvent);
    }

    public void fileArrived(int aX, ImageIcon aImage) {
        CTableHeaderEntry e = this.getHeaderOrNull(aX);
        if (e != null) {
            e.setIcon(aImage);
            this.repaint();
        }
    }
}

