/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CCell;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumnModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CRow;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CRowModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableCell;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableContent;
import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTableModel
extends AbstractTableModel {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTableModel.class);
    private static final long serialVersionUID = 1776288503645145820L;
    private final CColumn mDefaultColumn;
    private final CTable mTable;
    private final CColumnModel mColumnModel;
    private final CRowModel mRowModel;
    private final Map<Point, CCell> mCells = new HashMap<Point, CCell>();

    CTableModel(@NotNull CTable aTable) {
        this.mTable = aTable;
        this.mColumnModel = new CColumnModel(this);
        this.mRowModel = new CRowModel(this);
        this.mDefaultColumn = new CColumn(this.mColumnModel, "default", 0);
    }

    CRowModel getRowModel() {
        return this.mRowModel;
    }

    CColumnModel getColumnModel() {
        return this.mColumnModel;
    }

    @Override
    public void setValueAt(Object aValue, int aRowIndex, int aColumnIndex) {
        CCell cell = this.getOrAddCell(aColumnIndex, aRowIndex);
        if (cell != null) {
            cell.setValue(aValue);
            this.getTable().sendTableEvent(cell);
        }
        super.setValueAt(aValue, aRowIndex, aColumnIndex);
        this.fireTableCellUpdated(aRowIndex, aColumnIndex);
    }

    CTable getTable() {
        return this.mTable;
    }

    @Override
    public boolean isCellEditable(int aRowIndex, int aColumnIndex) {
        CColumn column = this.mColumnModel.getColumnByIndex(aColumnIndex);
        if (column != null) {
            return column.isEditable();
        }
        return this.mDefaultColumn.isEditable();
    }

    @Override
    public Object getValueAt(int aRowIndex, int aColumnIndex) {
        CCell cell;
        CRow row = this.getRowModel().getRowByIndex(aRowIndex);
        if (row != null && (cell = row.getCellByIndex(aColumnIndex)) != null) {
            return cell.getValue();
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int aColumnIndex) {
        CColumn column = this.mColumnModel.getColumnByIndex(aColumnIndex);
        if (column != null) {
            switch (column.getType()) {
                case bool: {
                    return Boolean.class;
                }
                case decimal: {
                    return Double.class;
                }
                case integer: {
                    return Long.class;
                }
            }
            return String.class;
        }
        return super.getColumnClass(aColumnIndex);
    }

    @Override
    public int getRowCount() {
        return this.mRowModel.size();
    }

    @Override
    public int getColumnCount() {
        return this.mColumnModel.size();
    }

    void clearRows() {
        this.mRowModel.clear();
        this.mCells.clear();
    }

    @Nullable
    CCell getCellOrNull(int aColumnIndex, int aRowIndex) {
        CRow row = this.mRowModel.getRowByIndex(aRowIndex);
        if (row != null) {
            return row.getCellByIndex(aColumnIndex);
        }
        return null;
    }

    @Nullable
    CCell getOrAddCell(@NotNull String aColumnId, @NotNull String aRowId) {
        CRow row = this.mRowModel.getOrAddRow(aRowId);
        return row.getOrAddCell(aColumnId);
    }

    @Nullable
    CCell getOrAddCell(int aColumnIndex, int aRowIndex) {
        CRow row = this.mRowModel.getRowByIndex(aRowIndex);
        if (row != null) {
            return row.getOrAddCellByIndex(aColumnIndex);
        }
        return null;
    }

    void resetCells() {
        for (CCell cell : this.mCells.values()) {
            cell.reset();
        }
    }

    void applyTableData(@NotNull CEventTableContent aEvent) {
        this.clearRows();
        Collection cells = aEvent.getCells();
        for (CEventTableCell dc : cells) {
            CCell cell = this.getOrAddCell(dc.getColumnId(), dc.getRowId());
            if (cell == null) continue;
            cell.setContent(dc);
        }
        this.fireTableStructureChanged();
    }
}

