/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model;

import de.sillysky.nyssr.remoteskin.model.CWidget;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class CRootWidgetList {
    private final Map<String, CWidget> mRootWidgets = new HashMap<String, CWidget>();

    public void add(CWidget aWidget) {
        this.mRootWidgets.put(aWidget.getId().getName(), aWidget);
    }

    public void collectRootWidgets(Collection<CWidget> aWidgets) {
        this.mRootWidgets.clear();
        for (CWidget w : aWidgets) {
            if (w.getParent() != null) continue;
            this.add(w);
        }
    }

    public void disposeAll() {
        SwingUtilities.invokeLater(() -> {
            for (CWidget w : this.mRootWidgets.values()) {
                Component component = w.getComponent();
                if (!(component instanceof Window)) continue;
                Window window = (Window)component;
                window.setVisible(false);
                window.dispose();
            }
            this.mRootWidgets.clear();
        });
    }

    public void hideAll() {
        for (CWidget w : this.mRootWidgets.values()) {
            w.getComponent().setVisible(false);
        }
    }

    public void remove(CWidget aWidget) {
        this.mRootWidgets.remove(aWidget.getId().getName());
    }
}

