/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.enums;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.SpringLayout;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public enum ELayout {
    UNKNOWN("unknown"),
    BORDER("BorderLayout"),
    BOX("BoxLayout"),
    CARD("CardLayout"),
    FLOW("FlowLayout"),
    GRID_BAG("GridBagLayout"),
    GRID("GridLayout"),
    GROUP("GroupLayout"),
    MIG("MigLayout"),
    SPRING("SpringLayout");

    private final String mValue;

    private ELayout(String aValue) {
        this.mValue = aValue;
    }

    @NotNull
    public static ELayout getByLayout(LayoutManager aLayout) {
        ELayout result = aLayout instanceof BorderLayout ? BORDER : (aLayout instanceof BoxLayout ? BOX : (aLayout instanceof CardLayout ? CARD : (aLayout instanceof FlowLayout ? FLOW : (aLayout instanceof GridBagLayout ? GRID_BAG : (aLayout instanceof GridLayout ? GRID : (aLayout instanceof GroupLayout ? GROUP : (aLayout instanceof SpringLayout ? SPRING : (aLayout instanceof MigLayout ? MIG : UNKNOWN))))))));
        return result;
    }

    @NotNull
    public static ELayout getByName(String aName) {
        ELayout[] arr;
        for (ELayout e : arr = ELayout.values()) {
            if (e.getValue().compareToIgnoreCase(aName) != 0) continue;
            return e;
        }
        return UNKNOWN;
    }

    @NotNull
    public String getValue() {
        return this.mValue;
    }
}

