/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventInsertText
implements IRemoteSkinEvent {
    private static final String TEXT = "text";
    private static final String POSITION = "position";
    private static final String APPEND = "append";
    private final String mText;
    private final Integer mPosition;
    private final Boolean mAppend;

    public CEventInsertText(@NotNull String aText) {
        this.mText = aText;
        this.mPosition = null;
        this.mAppend = null;
    }

    public CEventInsertText(@NotNull String aText, boolean aAppend) {
        this.mText = aText;
        this.mPosition = null;
        this.mAppend = aAppend;
    }

    public CEventInsertText(@NotNull String aText, int aPosition) {
        this.mText = aText;
        this.mPosition = aPosition;
        this.mAppend = null;
    }

    private CEventInsertText(@NotNull String aText, Integer aPosition, Boolean aAppend) {
        this.mText = aText;
        this.mPosition = aPosition;
        this.mAppend = null;
    }

    @Nullable
    public static CEventInsertText create(@Nullable Object aValue) {
        CJsonObject jo;
        String text;
        if (aValue instanceof CJsonObject && CUtilString.isValid((String)(text = CUtilJsonString.fromJson((CJsonObject)(jo = (CJsonObject)aValue), (String)TEXT, null)))) {
            Integer position = null;
            Object o = jo.getValue(POSITION);
            if (o != null) {
                position = CUtilInteger.fromObject((Object)aValue, (int)0);
            }
            Boolean append = null;
            o = jo.getValue(APPEND);
            if (o != null) {
                append = CUtilBoolean.fromObject((Object)aValue, (boolean)false);
            }
            return new CEventInsertText(text, position, append);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(TEXT, (Object)this.mText);
        if (this.mPosition != null) {
            jo.put(POSITION, (Object)this.mPosition);
        }
        if (this.mAppend != null) {
            jo.put(APPEND, (Object)this.mAppend);
        }
        return jo;
    }

    public String getText() {
        return this.mText;
    }

    public Integer getPosition() {
        return this.mPosition;
    }

    public Boolean getAppend() {
        return this.mAppend;
    }
}

