/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.ERelation;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeNode;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventInsertTreeNode
implements IRemoteSkinEvent {
    static final String NODES = "nodes";
    static final String RELATION = "relation";
    static final String RELATION_NODE_ID = "relationNodeId";
    private final CEventTreeNode mNode;
    private final String mRelationNodeId;
    private final ERelation mRelation;

    public CEventInsertTreeNode(CEventTreeNode aNode, String aRelationNodeId, ERelation aRelation) {
        this.mNode = aNode;
        this.mRelationNodeId = aRelationNodeId;
        this.mRelation = aRelation;
    }

    @Nullable
    public static CEventInsertTreeNode create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            Object o = jo.getValue(NODES);
            CEventTreeNode node = CEventTreeNode.create(o);
            ERelation relation = ERelation.child;
            o = jo.getValue(RELATION);
            if (o instanceof String) {
                relation = (ERelation)((Object)CUtilEnum.fromString(ERelation.class, (String)((String)o), (Object)((Object)ERelation.child)));
            }
            String relationNodeId = CUtilJsonString.fromJson((CJsonObject)jo, (String)RELATION_NODE_ID, (String)"");
            if (node != null && CUtilString.isValid((String)relationNodeId)) {
                return new CEventInsertTreeNode(node, relationNodeId, relation);
            }
        }
        return null;
    }

    public CEventTreeNode getNode() {
        return this.mNode;
    }

    public String getRelationNodeId() {
        return this.mRelationNodeId;
    }

    public ERelation getRelation() {
        return this.mRelation;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mRelation != null) {
            jo.put(RELATION, (Object)this.mRelation.name());
        }
        if (CUtilString.isValid((String)this.mRelationNodeId)) {
            jo.put(RELATION_NODE_ID, (Object)this.mRelationNodeId);
        }
        if (this.mNode != null) {
            jo.put(NODES, this.mNode.toJson());
        }
        return jo;
    }
}

