/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventInteger
implements IRemoteSkinEvent {
    public static final String INTEGER = "integer";
    private final int mValue;

    public CEventInteger(int aValue) {
        this.mValue = aValue;
    }

    @Nullable
    public static CEventInteger create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            int value = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)INTEGER, (int)Integer.MIN_VALUE);
            if (value != Integer.MIN_VALUE) {
                return new CEventInteger(value);
            }
        } else {
            int value;
            if (aValue instanceof Integer) {
                Integer value2 = (Integer)aValue;
                return new CEventInteger(value2);
            }
            if (aValue instanceof String && (value = CUtilInteger.fromObject((Object)aValue, (int)Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                return new CEventInteger(value);
            }
        }
        return null;
    }

    public int getValue() {
        return this.mValue;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(INTEGER, (Object)this.mValue);
        return jo;
    }
}

