/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelAttributes;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventLabelItem
implements IRemoteSkinEvent {
    static final String ID = "id";
    private final String mId;
    private final CEventLabelAttributes mAttributes;

    public CEventLabelItem(@NotNull String aId) {
        this.mId = aId;
        this.mAttributes = new CEventLabelAttributes();
    }

    public CEventLabelItem(@NotNull CEventLabelItem aEvent) {
        this.mId = aEvent.getId();
        this.mAttributes = new CEventLabelAttributes(aEvent.getAttributes());
    }

    @Nullable
    public static CEventLabelItem create(@Nullable Object aValue) {
        CJsonObject jo;
        String id;
        if (aValue instanceof CJsonObject && CUtilString.isValid((String)(id = CUtilJsonString.fromJson((CJsonObject)(jo = (CJsonObject)aValue), (String)ID, null)))) {
            CEventLabelItem event = new CEventLabelItem(id);
            CEventLabelAttributes labelAttributes = CEventLabelAttributes.create(jo);
            if (labelAttributes != null) {
                event.takeOver(labelAttributes);
            }
            return event;
        }
        return null;
    }

    private void takeOver(@NotNull CEventLabelAttributes aAttributes) {
        this.mAttributes.takeOver(aAttributes);
    }

    @NotNull
    public String toString() {
        return this.mAttributes.getDisplayedText();
    }

    public void toJson(@NotNull CJsonObject aJsonObject) {
        aJsonObject.put(ID, (Object)this.mId);
        this.mAttributes.toJson(aJsonObject);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        this.toJson(jo);
        return jo;
    }

    public String getId() {
        return this.mId;
    }

    public boolean equals(@Nullable Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CEventLabelItem that = (CEventLabelItem)aOther;
        return this.mId.equals(that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    @NotNull
    public CEventLabelAttributes getAttributes() {
        return this.mAttributes;
    }

    public void update(@NotNull CEventLabelItem aEntry) {
        this.mAttributes.update(aEntry.getAttributes());
    }
}

