/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.swing.margin.CMargin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventMargin
implements IRemoteSkinEvent {
    private static final int INVALID = -4758437;
    private static final String TOP = "top";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String BOTTOM = "bottom";
    private static final String LEFT_RIGHT = "leftRight";
    private static final String TOP_BOTTOM = "topBottom";
    private static final String ALL = "all";
    private final int mTop;
    private final int mLeft;
    private final int mRight;
    private final int mBottom;

    public CEventMargin(@NotNull CMargin aMargin) {
        this.mTop = aMargin.getTop();
        this.mLeft = aMargin.getLeft();
        this.mRight = aMargin.getRight();
        this.mBottom = aMargin.getBottom();
    }

    public CEventMargin(int aTop, int aLeft, int aBottom, int aRight) {
        this.mTop = aTop;
        this.mLeft = aLeft;
        this.mBottom = aBottom;
        this.mRight = aRight;
    }

    @Nullable
    public static CEventMargin create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            int lr;
            int tb;
            int top = 0;
            int left = 0;
            int right = 0;
            int bottom = 0;
            CJsonObject jo = (CJsonObject)aValue;
            int all = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)ALL, (int)-4758437);
            if (all != -4758437) {
                top = all;
                left = all;
                bottom = all;
                right = all;
            }
            if ((tb = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)TOP_BOTTOM, (int)-4758437)) != -4758437) {
                top = tb;
                bottom = tb;
            }
            if ((lr = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)LEFT_RIGHT, (int)-4758437)) != -4758437) {
                left = lr;
                right = lr;
            }
            top = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)TOP, (int)top);
            left = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)LEFT, (int)left);
            bottom = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)BOTTOM, (int)bottom);
            right = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)RIGHT, (int)right);
            return new CEventMargin(top, left, bottom, right);
        }
        if (aValue instanceof CMargin) {
            return new CEventMargin((CMargin)aValue);
        }
        return null;
    }

    public CMargin getMargin() {
        return new CMargin(this.mTop, this.mLeft, this.mBottom, this.mRight);
    }

    public int getTop() {
        return this.mTop;
    }

    public int getBottom() {
        return this.mBottom;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getRight() {
        return this.mRight;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(TOP, (Object)this.mTop);
        jo.put(LEFT, (Object)this.mLeft);
        jo.put(BOTTOM, (Object)this.mBottom);
        jo.put(RIGHT, (Object)this.mRight);
        return jo;
    }
}

