/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.events.border.CJsonBorderUtil;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class CEventCompoundBorder
implements IBorder {
    private final IBorder mOuterBorder;
    private final IBorder mInnerBorder;

    public CEventCompoundBorder(IBorder aOuterBorder, IBorder aInnerBorder) {
        this.mOuterBorder = aOuterBorder;
        this.mInnerBorder = aInnerBorder;
    }

    @Nullable
    public static CEventCompoundBorder create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            Object o = jo.getValue(EKeys.inner_border.name());
            IBorder innerBorder = CJsonBorderUtil.create(o);
            o = jo.getValue(EKeys.outer_border.name());
            IBorder outerBorder = CJsonBorderUtil.create(o);
            if (outerBorder != null && innerBorder != null) {
                return new CEventCompoundBorder(outerBorder, innerBorder);
            }
        }
        return null;
    }

    public IBorder getOuterBorder() {
        return this.mOuterBorder;
    }

    public IBorder getInnerBorder() {
        return this.mInnerBorder;
    }

    public CJsonObject toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(EKeys.border_type.name(), (Object)this.getType().name());
        jo.put(EKeys.inner_border.name(), this.mInnerBorder.toJson());
        jo.put(EKeys.outer_border.name(), this.mOuterBorder.toJson());
        return jo;
    }

    @Override
    public EBorderType getType() {
        return EBorderType.compound;
    }

    @Override
    public Border createBorder() {
        return BorderFactory.createCompoundBorder(this.mOuterBorder.createBorder(), this.mInnerBorder.createBorder());
    }

    private static enum EKeys {
        border_type,
        inner_border,
        outer_border;

    }
}

