/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.database.CH2Table;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.session.api.CRight;
import de.sillysky.nyssr.session.api.CRightList;
import java.io.PrintStream;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTableRight
extends CH2Table {
    protected CTableRight(@NotNull Connection aConnection, @NotNull ILogger aLogger, @NotNull String aName) {
        super(aConnection, aLogger, aName);
        this.createTable();
    }

    private void createTable() {
        if (!this.existTable("X052_ROLE_RIGHT")) {
            String sql = "CREATE TABLE IF NOT EXISTS X054_RIGHT(X054_RIGHT_ID VARCHAR not null,X054_DESCRIPTION VARCHAR,X054_PROTECTED BOOLEAN,PRIMARY KEY (X054_RIGHT_ID))";
            this.executeUpdate("CREATE TABLE IF NOT EXISTS X054_RIGHT(X054_RIGHT_ID VARCHAR not null,X054_DESCRIPTION VARCHAR,X054_PROTECTED BOOLEAN,PRIMARY KEY (X054_RIGHT_ID))", "createTable", null);
            this.add("NY_CreateUser", "Add a user", true);
            this.add("NY_UpdateUser", "Update user data", true);
            this.add("NY_DeleteUser", "Remove a user", true);
            this.add("NY_CreateRole", "Add a role", true);
            this.add("NY_EditRole", "Edit a role", true);
            this.add("NY_RemoveRoleFromUser", "Remove a role from the user", true);
            this.add("NY_DeleteRole", "Delete a role", true);
            this.add("NY_GrantRight", "Grant a right to a role", true);
            this.add("NY_RevokeRight", "Revoke a right from a role", true);
            this.add("NY_ChangeRight", "Change the description of a right", true);
            this.add("NY_GetRightList", "Get a list of rights", true);
            this.add("NY_GetListOfRoles", "Get list of roles", true);
            this.add("NY_DeleteRight", "Delete a right", true);
            this.add("NY_AddRoleToUser", "Assign a role to a user", true);
            this.add("NY_GetRoleData", "Get the data of a role", true);
            this.add("NY_GetRightData", "Get the data of a right", true);
            this.add("NY_GetRoles", "Get a list of roles", true);
            this.add("NY_VerifyUser", "Verify a user", true);
            this.add("NY_CreateRight", "Create a new right", true);
            this.add("NY_EditRight", "Edit a right", true);
            this.add("NY_ChangePassword", "Change the password", true);
            this.add("NY_StartAdminTool", "Start an Application reserved for Administrators", true);
            this.add("NY_GetUserData", "Get name and email of users", true);
            this.add("NY_GetUserList", "Get list of users", true);
            this.add("NY_Shutdown", "Shutdown or reboot a node", true);
            this.add("NY_SoftwareUpdate", "Update the software of a node", true);
            this.add("NY_EditConfiguration", "Edit the configuration of a node", true);
        }
    }

    void add(@NotNull String aRightId, @NotNull String aDescription, boolean aProtected) {
        String sql = "INSERT INTO X054_RIGHT (X054_RIGHT_ID,X054_DESCRIPTION,X054_PROTECTED) VALUES (?, ?, ?)";
        this.executeUpdate("INSERT INTO X054_RIGHT (X054_RIGHT_ID,X054_DESCRIPTION,X054_PROTECTED) VALUES (?, ?, ?)", "addRight", statement -> {
            statement.setString(1, aRightId);
            statement.setString(2, aDescription);
            statement.setBoolean(3, aProtected);
        });
    }

    CResult remove(String aRightId) {
        if (this.isProtected(aRightId)) {
            return new CResult(5501, "Right is protected.");
        }
        String sql = "DELETE FROM X054_RIGHT WHERE X054_RIGHT_ID = ? AND X054_PROTECTED = false";
        this.executeUpdate("DELETE FROM X054_RIGHT WHERE X054_RIGHT_ID = ? AND X054_PROTECTED = false", "deleteRight", statement -> statement.setString(1, aRightId));
        return null;
    }

    void deleteAll() {
        String sql = "DELETE FROM X054_RIGHT WHERE X054_PROTECTED = false";
        this.executeUpdate("DELETE FROM X054_RIGHT WHERE X054_PROTECTED = false", "deleteAll", null);
    }

    void dump(PrintStream aStream) {
        String sql = "SELECT X054_RIGHT_ID, X054_DESCRIPTION FROM X054_RIGHT ORDER BY X054_RIGHT_ID";
        this.executeQuery("SELECT X054_RIGHT_ID, X054_DESCRIPTION FROM X054_RIGHT ORDER BY X054_RIGHT_ID", "dump", null, rs -> {
            while (rs.next()) {
                aStream.print(rs.getString(1));
                aStream.print(" (");
                aStream.println(rs.getString(2));
            }
            return null;
        });
    }

    int getCount() {
        String sql = "SELECT COUNT(*) FROM X054_RIGHT";
        return (int)this.executeQueryLong("SELECT COUNT(*) FROM X054_RIGHT", "getRightCount", null);
    }

    CRightList getList() {
        String sql = "SELECT X054_RIGHT_ID, X054_DESCRIPTION, X054_PROTECTED FROM X054_RIGHT ORDER BY X054_RIGHT_ID";
        return (CRightList)this.executeQuery("SELECT X054_RIGHT_ID, X054_DESCRIPTION, X054_PROTECTED FROM X054_RIGHT ORDER BY X054_RIGHT_ID", "getRights", null, rs -> {
            CRightList result = new CRightList();
            while (rs.next()) {
                String rightId = rs.getString(1);
                String desc = rs.getString(2);
                boolean isProtected = rs.getBoolean(3);
                result.add(new CRight(rightId, desc, isProtected));
            }
            return result;
        });
    }

    boolean exists(@NotNull String aRightId) {
        String sql = "SELECT COUNT(*) FROM X054_RIGHT WHERE X054_RIGHT_ID=?";
        long count = this.executeQueryLong("SELECT COUNT(*) FROM X054_RIGHT WHERE X054_RIGHT_ID=?", "rightExists", statement -> statement.setString(1, aRightId));
        return count == 1L;
    }

    boolean isProtected(@NotNull String aRightId) {
        String sql = "SELECT X054_PROTECTED FROM X054_RIGHT WHERE X054_RIGHT_ID=?";
        Boolean isProtected = (Boolean)this.executeQuery("SELECT X054_PROTECTED FROM X054_RIGHT WHERE X054_RIGHT_ID=?", "isProtected", statement -> statement.setString(1, aRightId), rs -> {
            boolean p = false;
            while (rs.next()) {
                p = rs.getBoolean(1);
            }
            return p;
        });
        return Boolean.TRUE.equals(isProtected);
    }

    @Nullable
    public CRight getRightRecord(@NotNull String aRightId) {
        String sql = "SELECT X054_RIGHT_ID,X054_DESCRIPTION, X054_PROTECTED FROM X054_RIGHT WHERE X054_RIGHT_ID=?";
        return (CRight)this.executeQuery("SELECT X054_RIGHT_ID,X054_DESCRIPTION, X054_PROTECTED FROM X054_RIGHT WHERE X054_RIGHT_ID=?", "getRightRecord", statement -> statement.setString(1, aRightId), rs -> {
            if (rs.next()) {
                String rightId = rs.getString(1);
                String description = rs.getString(2);
                boolean isProtected = rs.getBoolean(3);
                return new CRight(rightId, description, isProtected);
            }
            return null;
        });
    }

    public void updateRight(@NotNull String aRightId, @NotNull String aDescription) {
        String sql = "UPDATE X054_RIGHT SET X054_DESCRIPTION = ? WHERE X054_RIGHT_ID=?";
        this.executeUpdate("UPDATE X054_RIGHT SET X054_DESCRIPTION = ? WHERE X054_RIGHT_ID=?", "updateRight", statement -> {
            statement.setString(1, aDescription);
            statement.setString(2, aRightId);
        });
    }
}

