/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.database.CH2Table;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.crypt.CBCrypt;
import de.sillysky.nyssr.util.hash.CUtilPassword;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import de.sillysky.nyssr.util.time.CUtilTimestamp;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTableUser
extends CH2Table {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"session");

    public CTableUser(@NotNull Connection aConnection, @NotNull ILogger aLogger, @NotNull String aName) {
        super(aConnection, aLogger, aName);
        this.createTable();
    }

    private void createTable() {
        if (!this.existTable("X050_USER")) {
            String sql = "CREATE TABLE IF NOT EXISTS X050_USER(X050_USER_ID VARCHAR not null,X050_REAL_NAME VARCHAR,X050_EMAIL VARCHAR,X050_PICTURE VARCHAR,X050_PASSWORD VARCHAR not null,X050_TIME_CREATED TIMESTAMP default now() not null,X050_CREATED_BY VARCHAR,X050_FORCE_PW_CHANGE BOOLEAN default true,constraint X050_USER_PK primary key (X050_USER_ID))";
            this.executeUpdate("CREATE TABLE IF NOT EXISTS X050_USER(X050_USER_ID VARCHAR not null,X050_REAL_NAME VARCHAR,X050_EMAIL VARCHAR,X050_PICTURE VARCHAR,X050_PASSWORD VARCHAR not null,X050_TIME_CREATED TIMESTAMP default now() not null,X050_CREATED_BY VARCHAR,X050_FORCE_PW_CHANGE BOOLEAN default true,constraint X050_USER_PK primary key (X050_USER_ID))", "createTable", null);
            if (this.getCount() == 0) {
                this.add("admin", "Administrator", "admin@sillysky.net", "user/admin.jpg", "admin", "sillysky", false, true);
                this.add("guest", "The guest", "guest@sillysky.net", "", "admin", "sillysky", false, false);
            }
        }
    }

    void deleteAll() {
        String sql = "DELETE FROM X050_USER";
        this.executeUpdate("DELETE FROM X050_USER", "deleteAll", null);
    }

    void removeUser(String aUserId) {
        String sql = "DELETE FROM X050_USER WHERE X050_USER_ID = ?";
        this.executeUpdate("DELETE FROM X050_USER WHERE X050_USER_ID = ?", "deleteUser", statement -> statement.setString(1, aUserId));
    }

    void dump(PrintStream aStream) {
        String sql = "SELECT X050_USER_ID, X050_TIME_CREATED, X050_CREATED_BY FROM X050_USER ORDER BY X050_USER_ID";
        this.executeQuery("SELECT X050_USER_ID, X050_TIME_CREATED, X050_CREATED_BY FROM X050_USER ORDER BY X050_USER_ID", "dump", null, rs -> {
            while (rs.next()) {
                aStream.print(rs.getString(1));
                aStream.print(" CREATED ");
                aStream.print(rs.getTimestamp(2));
                aStream.print(" BY ");
                aStream.println(rs.getString(3));
            }
            return null;
        });
    }

    int getCount() {
        String sql = "SELECT COUNT(*) FROM X050_USER";
        return (int)this.executeQueryLong("SELECT COUNT(*) FROM X050_USER", "getUserCount", null);
    }

    List<String> getList() {
        String sql = "SELECT X050_USER_ID FROM X050_USER ORDER BY X050_USER_ID";
        return (List)this.executeQuery("SELECT X050_USER_ID FROM X050_USER ORDER BY X050_USER_ID", "getUsers", null, rs -> {
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                String userId = rs.getString(1);
                result.add(userId);
            }
            return result;
        });
    }

    boolean verifyPassword(@NotNull String aUserId, @NotNull String aPassword) {
        String sql = "SELECT X050_PASSWORD FROM X050_USER WHERE X050_USER_ID=?";
        String password = (String)this.executeQuery("SELECT X050_PASSWORD FROM X050_USER WHERE X050_USER_ID=?", "getPassword", st -> st.setString(1, aUserId), rs -> {
            if (rs.next()) {
                return rs.getString(1);
            }
            return null;
        });
        if (password == null) {
            return false;
        }
        return this.checkPassword(password, aPassword);
    }

    void add(@NotNull String aUserId, @NotNull String aRealName, @NotNull String aEmail, @NotNull String aPicture, @NotNull String aCreatedBy, @NotNull String aPassword, boolean aPasswordIsPreHashed, boolean aForcePwChange) {
        String sql = "INSERT INTO X050_USER (X050_USER_ID,X050_REAL_NAME,X050_EMAIL,X050_PICTURE,X050_PASSWORD,X050_TIME_CREATED,X050_CREATED_BY,X050_FORCE_PW_CHANGE) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        this.executeUpdate("INSERT INTO X050_USER (X050_USER_ID,X050_REAL_NAME,X050_EMAIL,X050_PICTURE,X050_PASSWORD,X050_TIME_CREATED,X050_CREATED_BY,X050_FORCE_PW_CHANGE) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", "insert", statement -> {
            statement.setString(1, aUserId);
            statement.setString(2, aRealName);
            statement.setString(3, aEmail);
            statement.setString(4, aPicture);
            statement.setString(5, this.hashPassword(aPassword, aPasswordIsPreHashed));
            statement.setTimestamp(6, CUtilTimestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.now()));
            statement.setString(7, aCreatedBy);
            statement.setBoolean(8, aForcePwChange);
        });
    }

    boolean changePassword(@NotNull String aUserId, @NotNull String aCurrentPassword, @NotNull String aNewPassword) {
        boolean success = this.verifyPassword(aUserId, aCurrentPassword);
        if (success) {
            String sql = "UPDATE X050_USER SET X050_PASSWORD = ? WHERE X050_USER_ID=?";
            this.executeUpdate("UPDATE X050_USER SET X050_PASSWORD = ? WHERE X050_USER_ID=?", "changePassword", statement -> {
                statement.setString(1, this.hashPassword(aNewPassword, true));
                statement.setString(2, aUserId);
            });
        }
        return success;
    }

    boolean exists(@NotNull String aUserId) {
        String sql = "SELECT COUNT(*) FROM X050_USER WHERE X050_USER_ID=?";
        long count = this.executeQueryLong("SELECT COUNT(*) FROM X050_USER WHERE X050_USER_ID=?", "userExists", statement -> statement.setString(1, aUserId));
        return count == 1L;
    }

    @Nullable
    CUser getUserRecord(@NotNull String aUserId) {
        String sql = "SELECT X050_USER_ID,X050_REAL_NAME,X050_EMAIL,X050_PICTURE,X050_TIME_CREATED,X050_CREATED_BY FROM X050_USER WHERE X050_USER_ID=?";
        return (CUser)this.executeQuery("SELECT X050_USER_ID,X050_REAL_NAME,X050_EMAIL,X050_PICTURE,X050_TIME_CREATED,X050_CREATED_BY FROM X050_USER WHERE X050_USER_ID=?", "getUserRecord", statement -> statement.setString(1, aUserId), rs -> {
            if (rs.next()) {
                String userId = rs.getString(1);
                String realName = rs.getString(2);
                String email = rs.getString(3);
                String picture = rs.getString(4);
                Timestamp ts = rs.getTimestamp(5);
                String createdBy = rs.getString(6);
                LocalDateTime ldt = CUtilLocalDateTime.fromTimestamp((Timestamp)ts);
                return new CUser(userId, realName, email, picture, createdBy, ldt == null ? LocalDateTime.now() : ldt);
            }
            return null;
        });
    }

    public void updateUserData(@NotNull CUser aUser) {
        String sql = "UPDATE X050_USER SET X050_REAL_NAME = ?, X050_EMAIL = ?, X050_PICTURE = ? WHERE X050_USER_ID=?";
        LOG.debug("--- Change user data: userId={}, realName={}, EMail={}, Picture={}", new Object[]{aUser.getId(), aUser.getRealName(), aUser.getEmail(), aUser.getPicture()});
        this.executeUpdate("UPDATE X050_USER SET X050_REAL_NAME = ?, X050_EMAIL = ?, X050_PICTURE = ? WHERE X050_USER_ID=?", "changePassword", statement -> {
            statement.setString(1, aUser.getRealName());
            statement.setString(2, aUser.getEmail());
            statement.setString(3, aUser.getPicture());
            statement.setString(4, aUser.getId());
        });
    }

    @NotNull
    private String hashPassword(@NotNull String aPassword, boolean aBase64Encoded) {
        if (aPassword.isEmpty()) {
            return "";
        }
        String base64 = aBase64Encoded ? aPassword : CUtilPassword.hashPassword((char[])aPassword.toCharArray());
        return CBCrypt.hashpw((String)base64, (String)CBCrypt.gensalt((int)12));
    }

    private boolean checkPassword(String aPasswordFromDatabase, String aPasswordToCheck) {
        if (CUtilString.isEmpty((String)aPasswordFromDatabase)) {
            return aPasswordToCheck.isEmpty();
        }
        return CBCrypt.checkpw((String)aPasswordToCheck, (String)aPasswordFromDatabase);
    }
}

