/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.editrole;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.web.dialog.editrole.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick2;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.CRole;
import de.sillysky.nyssr.session.api.records.CRecordUserDbGetRoleRecord;
import de.sillysky.nyssr.session.api.records.CRecordUserDbUpdateRoleRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00307EditRole
extends CTarget {
    private final byte[] mSessionToken;
    private final CTargetAddress mClientTargetAddress;
    private final CTargetAddress mOwnerTargetAddress;
    private final String mRoleId;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private static final String ID_INDEX_MODAL = "rs_30cb3f8d-cefd-40c5-81b8-7791895c7b95";
    private static final String ID_00307_MODAL = "id_00307_modal";
    private static final String ID_00307_CANCEL = "id_00307_cancel";
    private static final String ID_00307_SAVE = "id_00307_save";
    private static final String ID_00307_BY = "id_00307_by";
    private static final String ID_00307_DESCRIPTION = "id_00307_description";
    private static final String ID_00307_ROLE_ID = "id_00307_role_id";
    private static final String[] WIDGETS = new String[]{"id_00307_cancel", "id_00307_save"};
    private CTargetAddress mUserDbAddress;
    private CRole mRole;

    public C00307EditRole(byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aRoleId) {
        this.mSessionToken = aSessionToken;
        this.mClientTargetAddress = aClientTargetAddress;
        this.mOwnerTargetAddress = aOwnerTargetAddress;
        this.mRoleId = aRoleId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebDismissDialog.ID, this::asyncWebDismissDialog);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordWebNotifyClick2.ID, this::asyncWebNotifyClick2);
        this.addMessageHandler(CRecordUserDbGetRoleRecord.ID, this::asyncGetRoleRecord);
        this.addMessageHandler(CRecordUserDbUpdateRoleRecord.ID, this::asyncUserDbUpdateRoleRecord);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mClientTargetAddress);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mClientTargetAddress);
        this.sendGetRoleData(this.mRoleId);
        this.mWebApi.registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebDismissDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(3);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (values != null) {
            String description = values.get(ID_00307_DESCRIPTION, "");
            this.sendSetRoleData(this.mRoleId, description);
        } else {
            this.finish(1);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick2(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.finish(2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRoleRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mUserDbAddress = aEnvelope.getSender();
            if (aEnvelope.getResult().isSuccess()) {
                CRecord roleRecord = CRecordUserDbGetRoleRecord.getRoleRecord((CRecord)aRecord, null);
                this.mRole = CRole.fromRecord((CRecord)roleRecord);
                this.showDialog();
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private boolean asyncUserDbUpdateRoleRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mUserDbAddress = aEnvelope.getSender();
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.finish(0);
            } else {
                this.finish(1);
            }
            return true;
        }
        return false;
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00307_edit_role.html");
        this.mWebApi.removeElement(ID_00307_MODAL);
        this.mWebApi.setInnerHtml(ID_INDEX_MODAL, main);
        this.mWebApi.setValue(ID_00307_ROLE_ID, this.mRoleId);
        String description = this.mRole.getDescription();
        if (CUtilString.isValid((String)description)) {
            this.mWebApi.setValue(ID_00307_DESCRIPTION, description);
        }
        this.mWebApi.setValue(ID_00307_BY, this.mRole.getTimeCreated() + " by " + this.mRole.getCreatedByUser());
        this.mWebApi.showModal(ID_00307_MODAL);
        this.mWebApi.addClickListener1(ID_00307_SAVE, new String[]{ID_00307_ROLE_ID, ID_00307_DESCRIPTION});
        this.mWebApi.addClickListener2(new String[]{ID_00307_CANCEL});
    }

    private void sendGetRoleData(@NotNull String aId) throws CException {
        CRecord record = CRecordUserDbGetRoleRecord.create();
        CRecordUserDbGetRoleRecord.setRoleId((CRecord)record, (String)aId);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(this.mSessionToken);
        this.sendRequest(env, aRecord);
    }

    private void sendSetRoleData(@NotNull String aRoleId, @NotNull String aDescription) throws CException {
        CRecord record = CRecordUserDbUpdateRoleRecord.create();
        CRecordUserDbUpdateRoleRecord.setRoleId((CRecord)record, (String)aRoleId);
        CRecordUserDbUpdateRoleRecord.setDescription((CRecord)record, (String)aDescription);
        this.sendMessageToSessionManager(record);
    }

    private void finish(int aReason) throws CException {
        this.mWebApi.removeElement(ID_00307_MODAL);
        this.mWebDialogApi.notifyDismissed(this.mOwnerTargetAddress, CConstants.MICRO_SERVICE_ID, aReason, null);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }
}

