/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventLayoutConstraints;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventCreateWidget
implements IRemoteSkinEvent {
    public static final String KEY_WIDGET_ID = "widgetId";
    public static final String KEY_PARENT_ID = "parentId";
    public static final String KEY_WIDGET_TYPE = "widgetType";
    public static final String KEY_CONSTRAINTS = "constraints";
    private final String mWidgetType;
    private final CWidgetId mWidgetId;
    private final CWidgetId mParentId;
    private final CEventLayoutConstraints mConstraints;

    public CEventCreateWidget(@NotNull String aWidgetType, @NotNull CWidgetId aWidgetId, @Nullable CWidgetId aParentId, @Nullable CEventLayoutConstraints aConstraints) {
        this.mWidgetType = aWidgetType;
        this.mWidgetId = aWidgetId;
        this.mParentId = aParentId;
        this.mConstraints = aConstraints;
    }

    @Nullable
    public static CEventCreateWidget create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String widgetType = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_WIDGET_TYPE, null);
            Object o = jo.getValue(KEY_WIDGET_ID);
            CEventWidgetId w = CEventWidgetId.create(o);
            o = jo.getValue(KEY_PARENT_ID);
            CEventWidgetId p = CEventWidgetId.create(o);
            if (CUtilString.isValid((String)widgetType) && w != null) {
                CEventLayoutConstraints event = CEventLayoutConstraints.create(jo.getValue(KEY_CONSTRAINTS));
                return new CEventCreateWidget(widgetType, w.getWidgetId(), p == null ? null : p.getWidgetId(), event);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(KEY_WIDGET_TYPE, (Object)this.mWidgetType);
        CEventWidgetId dw = new CEventWidgetId(this.mWidgetId);
        jo.put(KEY_WIDGET_ID, dw.toJson());
        if (this.mParentId != null) {
            CEventWidgetId p = new CEventWidgetId(this.mParentId);
            jo.put(KEY_PARENT_ID, p.toJson());
        }
        if (this.mConstraints != null) {
            jo.put(KEY_CONSTRAINTS, this.mConstraints.toJson());
        }
        return jo;
    }

    @NotNull
    public CWidgetId getWidgetId() {
        return this.mWidgetId;
    }

    @Nullable
    public CWidgetId getParentId() {
        return this.mParentId;
    }

    @NotNull
    public String getWidgetType() {
        return this.mWidgetType;
    }

    @Nullable
    public CEventLayoutConstraints getConstraints() {
        return this.mConstraints;
    }
}

