/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonFloat;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventDashedBorder
implements IBorder,
IRemoteSkinEvent {
    private final Color mColor;
    private final float mThickness;
    private final float mLength;
    private final float mSpacing;
    private final boolean mRounded;

    public CEventDashedBorder(@NotNull Color aColor, float aThickness, float aLength, float aSpacing, boolean aRounded) {
        this.mColor = aColor;
        this.mThickness = aThickness;
        this.mLength = aLength;
        this.mSpacing = aSpacing;
        this.mRounded = aRounded;
    }

    @Nullable
    public static CEventDashedBorder create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            Object o = jo.getValue(EKeys.color.name());
            CEventColor dc = CEventColor.create(o);
            Color color = dc == null ? Color.BLACK : dc.createColor();
            float thickness = CUtilJsonFloat.fromJson((CJsonObject)jo, (String)EKeys.thickness.name(), (float)-1.0f);
            float length = CUtilJsonFloat.fromJson((CJsonObject)jo, (String)EKeys.length.name(), (float)-1.0f);
            float spacing = CUtilJsonFloat.fromJson((CJsonObject)jo, (String)EKeys.spacing.name(), (float)-1.0f);
            boolean rounded = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)EKeys.rounded.name(), (boolean)false);
            return new CEventDashedBorder(color, thickness, length, spacing, rounded);
        }
        return null;
    }

    public Color getColor() {
        return this.mColor;
    }

    public float getThickness() {
        return this.mThickness;
    }

    public float getLength() {
        return this.mLength;
    }

    public float getSpacing() {
        return this.mSpacing;
    }

    public boolean isRounded() {
        return this.mRounded;
    }

    @Override
    public Border createBorder() {
        if (this.mThickness >= 1.0f && this.mLength >= 1.0f && this.mSpacing >= 0.0f) {
            return BorderFactory.createDashedBorder(this.mColor, this.mThickness, this.mLength, this.mSpacing, this.mRounded);
        }
        if (this.mLength >= 1.0f && this.mSpacing >= 0.0f) {
            return BorderFactory.createDashedBorder(this.mColor, this.mLength, this.mSpacing);
        }
        return BorderFactory.createDashedBorder(this.mColor);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(EKeys.border_type.name(), (Object)this.getType().name());
        Object o = new CEventColor(this.mColor).toJson();
        jo.put(EKeys.color.name(), o);
        jo.put(EKeys.thickness.name(), (Object)Float.valueOf(this.mThickness));
        jo.put(EKeys.length.name(), (Object)Float.valueOf(this.mLength));
        jo.put(EKeys.spacing.name(), (Object)Float.valueOf(this.mSpacing));
        jo.put(EKeys.rounded.name(), (Object)this.mRounded);
        return jo;
    }

    @Override
    public EBorderType getType() {
        return EBorderType.dashed;
    }

    public static enum EKeys {
        border_type,
        color,
        length,
        spacing,
        thickness,
        rounded;

    }
}

