/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.dialogs;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventShowSelectDialog
implements IRemoteSkinEvent {
    public static final String TITLE = "title";
    public static final String TEXT = "text";
    public static final String LIST = "list";
    public static final String SELECTION = "selection";
    public static final String ICON = "icon";
    public static final String DEFAULT_TITLE = "Select an entry:";
    public static final String DEFAULT_TEXT = "";
    public static final String DEFAULT_SELECTION = null;
    private final List<String> mList = new ArrayList<String>();
    private String mSelection;
    private String mText;
    private CEventIcon mIcon;
    private String mTitle;

    @Nullable
    public static CEventShowSelectDialog create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventShowSelectDialog event = new CEventShowSelectDialog();
            String title = CUtilJsonString.fromJson((CJsonObject)jo, (String)TITLE, (String)DEFAULT_TITLE);
            event.setTitle(title);
            String text = CUtilJsonString.fromJson((CJsonObject)jo, (String)TEXT, (String)DEFAULT_TEXT);
            event.setText(text);
            String selection = CUtilJsonString.fromJson((CJsonObject)jo, (String)SELECTION, (String)DEFAULT_SELECTION);
            event.setSelection(selection);
            Object value = jo.getValue(LIST);
            if (value instanceof CJsonArray) {
                for (Object o : ((CJsonArray)value).getChildren()) {
                    event.addListEntry(o.toString());
                }
            }
            CEventIcon icon = CEventIcon.fromObject(jo.getValue(ICON));
            event.setIcon(icon);
            return event;
        }
        return null;
    }

    public void addListEntry(@NotNull String aText) {
        this.mList.add(aText);
    }

    @Nullable
    public CEventIcon getIcon() {
        return this.mIcon;
    }

    public void setIcon(CEventIcon aIcon) {
        this.mIcon = aIcon;
    }

    @NotNull
    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String aTitle) {
        this.mTitle = aTitle;
    }

    @NotNull
    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    @NotNull
    public String getSelection() {
        return this.mSelection;
    }

    public void setSelection(String aSelection) {
        this.mSelection = aSelection;
    }

    public List<String> getList() {
        return this.mList;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (!DEFAULT_TITLE.equals(this.mTitle)) {
            jo.put(TITLE, (Object)this.mTitle);
        }
        if (!DEFAULT_TEXT.equals(this.mTitle)) {
            jo.put(TEXT, (Object)this.mText);
        }
        if (CUtilString.isValid((String)this.mSelection)) {
            jo.put(SELECTION, (Object)this.mSelection);
        }
        CJsonArray ja = new CJsonArray();
        for (String s : this.mList) {
            ja.add((Object)s);
        }
        jo.put(LIST, (Object)ja);
        if (this.mIcon != null) {
            jo.put(ICON, this.mIcon.toJson());
        }
        return jo;
    }
}

