/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.context.target;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.remoteskin.client.context.target.CFileEntry;
import de.sillysky.nyssr.impl.remoteskin.client.context.target.CFileRequester;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CFileEntryList {
    private final Map<String, CFileEntry> mPendingFiles = new HashMap<String, CFileEntry>();

    CFileEntryList() {
    }

    UUID add(@NotNull String aPath, @NotNull CWidgetId aWidgetId, @Nullable Object aToken, @NotNull String aFileDeliveryType) {
        CFileEntry entry = this.mPendingFiles.get(aPath);
        CFileRequester requester = new CFileRequester(aWidgetId, aToken, aFileDeliveryType);
        if (entry != null) {
            entry.addRequester(requester);
            return null;
        }
        entry = new CFileEntry(aPath, requester);
        this.mPendingFiles.put(aPath, entry);
        return entry.getTransactionId();
    }

    @Nullable
    CFileEntry get(@NotNull UUID aTransactionId) {
        for (CFileEntry e : this.mPendingFiles.values()) {
            UUID transactionId = e.getTransactionId();
            if (!transactionId.equals(aTransactionId)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    CFileEntry remove(@NotNull UUID aTransactionId) {
        Iterator<CFileEntry> it = this.mPendingFiles.values().iterator();
        while (it.hasNext()) {
            CFileEntry fe = it.next();
            if (!aTransactionId.equals(fe.getTransactionId())) continue;
            it.remove();
            return fe;
        }
        return null;
    }
}

