/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.icon.store;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.util.hash.CMd5;
import java.util.Objects;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CIconEntry {
    private final String mName;
    private final String mDescription;
    private CNodeAddress mOrigin;
    private String mMd5;
    private ImageIcon mIcon;

    CIconEntry(@NotNull String aName, @NotNull String aDescription, byte @NotNull [] aBytes, @Nullable CNodeAddress aOrigin) {
        this.mName = aName;
        this.mDescription = aDescription;
        this.setBytes(aBytes, aOrigin);
    }

    CIconEntry(@NotNull String aName, @NotNull String aDescription, @NotNull CNodeAddress aOrigin) {
        this.mName = aName;
        this.mDescription = aDescription;
        this.mIcon = null;
        this.mMd5 = null;
        this.mOrigin = aOrigin;
    }

    void setBytes(byte @NotNull [] aBytes, @Nullable CNodeAddress aOrigin) {
        this.mIcon = new ImageIcon(aBytes, this.mDescription);
        this.mMd5 = CMd5.createByData((byte[])aBytes).toBase64();
        this.mOrigin = aOrigin;
    }

    @Nullable
    ImageIcon getIcon() {
        return this.mIcon;
    }

    @Nullable
    CNodeAddress getOrigin() {
        return this.mOrigin;
    }

    @NotNull
    public String getName() {
        return this.mName;
    }

    @NotNull
    String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public String getMd5() {
        return this.mMd5;
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CIconEntry that = (CIconEntry)aOther;
        return this.mName.equals(that.mName);
    }

    public int hashCode() {
        return Objects.hash(this.mName);
    }

    public String toString() {
        return this.mName + ":" + this.mDescription;
    }
}

