/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.command;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.json.IJsonParser;
import de.sillysky.nyssr.remoteskin.model.command.CAttributeEntry;
import de.sillysky.nyssr.remoteskin.model.command.CListOfAttributes;
import de.sillysky.nyssr.remoteskin.model.command.IJsonCommandParser;
import de.sillysky.nyssr.remoteskin.model.keys.ENotificationJsonKeys;
import de.sillysky.nyssr.util.CUtilString;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CJsonCommandParser
implements IJsonCommandParser {
    private final IJsonParser mParser;
    private final CListOfAttributes mAttributes = new CListOfAttributes();

    public CJsonCommandParser(IJsonParser aParser) {
        this.mParser = aParser;
    }

    @NotNull
    public CListOfAttributes parse(@Nullable String aJson) throws CException {
        if (CUtilString.isValid((String)aJson)) {
            CJsonObject root = this.mParser.parse(aJson, true);
            this.readAttributes(root);
        }
        return this.mAttributes;
    }

    public void readAttributes(CJsonObject aRoot) {
        CJsonArray aa = (CJsonArray)aRoot.getValue(ENotificationJsonKeys.attributes.name());
        CUtilCheck.checkNotNull((Object)aa, (String)"Attributes not found", (Object[])new Object[0]);
        for (Object child : aa.getChildren()) {
            CJsonArray arr;
            List children;
            if (!(child instanceof CJsonArray) || (children = (arr = (CJsonArray)child).getChildren()).size() != 3) continue;
            CWidgetId widgetId = null;
            String key = null;
            int i = 0;
            for (Object o : children) {
                switch (i) {
                    case 0: {
                        if (!(o instanceof String)) break;
                        widgetId = CWidgetId.create((String)((String)o));
                        break;
                    }
                    case 1: {
                        if (!(o instanceof String)) break;
                        key = (String)o;
                        break;
                    }
                    case 2: {
                        if (widgetId == null || !widgetId.isValid() || key == null || o == null) break;
                        CAttributeEntry cmd = new CAttributeEntry(widgetId, key, o);
                        this.mAttributes.add(cmd);
                    }
                }
                ++i;
            }
        }
    }
}

