/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.context;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.remoteskin.server.context.CWidgetApi;
import de.sillysky.nyssr.impl.remoteskin.server.context.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.CModelConstants;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.command.CAttributeEntry;
import de.sillysky.nyssr.remoteskin.model.command.CListOfAttributes;
import de.sillysky.nyssr.remoteskin.model.command.IJsonCommandParser;
import de.sillysky.nyssr.remoteskin.model.command.IJsonCommandSender;
import de.sillysky.nyssr.remoteskin.model.events.CEventCreateWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventGlobalProperties;
import de.sillysky.nyssr.remoteskin.model.events.CEventMountWidgetSet;
import de.sillysky.nyssr.remoteskin.model.events.CEventUnmountWidget;
import de.sillysky.nyssr.remoteskin.model.records.CRecordRemoteSkinApplyAttributes;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContextListener;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWidgetSetMountedListener;
import de.sillysky.nyssr.remoteskin.server.widgets.CMessageBox;
import de.sillysky.nyssr.remoteskin.server.widgets.CServerWidget;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CRemoteSkinServerContext
extends CTarget
implements IRemoteSkinServerContext {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinServerContext.class);
    private final ITarget mSenderTarget;
    private final IDependencies mDependencies;
    private final Map<CWidgetId, CServerWidget> mWidgets = new HashMap<CWidgetId, CServerWidget>();
    private final CWidgetApi mWidgetApi;
    private IJsonCommandSender mSender;
    private IRemoteSkinClientContext mClientContext;

    CRemoteSkinServerContext(@NotNull IDependencies aDependencies, @Nullable IRemoteSkinClientContext aClientContext) {
        this.mDependencies = aDependencies;
        this.mClientContext = aClientContext;
        this.mSenderTarget = null;
        this.mSender = this.mDependencies.getJsonCommandFactory().createSender();
        this.mWidgetApi = new CWidgetApi(this.mSender);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordRemoteSkinApplyAttributes.ID, this::asyncApplyAttributes);
    }

    public CRemoteSkinServerContext(IDependencies aDependencies) {
        this(aDependencies, null);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncApplyAttributes(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.applyNotification(aRecord);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void sendUpdate() {
        if (!this.mSender.isEmpty()) {
            if (this.mClientContext == null) {
                LOG.error("Can't send mMessage to RemoteSkin. ClientContext is null.");
            }
            this.mSender.send(this.mClientContext.getTargetAddress(), (ITarget)(this.mSenderTarget == null ? this : this.mSenderTarget));
            this.mSender = this.mDependencies.getJsonCommandFactory().createSender();
            this.mWidgetApi.setSender(this.mSender);
        }
    }

    @NotNull
    public IJsonCommandSender getSender() {
        return this.mSender;
    }

    public <T extends CServerWidget> T addWidget(@NotNull T aWidget) {
        this.mWidgets.put(aWidget.getWidgetId(), aWidget);
        aWidget.setServerContext((IRemoteSkinServerContext)this);
        return aWidget;
    }

    public void removeWidget(@NotNull CWidgetId aWidgetId) {
        CServerWidget removed = this.mWidgets.remove(aWidgetId);
        if (removed != null) {
            removed.setServerContext(null);
        }
    }

    public void applyNotification(@NotNull CRecord aRecord) throws CException {
        String json = CRecordRemoteSkinApplyAttributes.getJson((CRecord)aRecord, null);
        if (json != null) {
            IJsonCommandParser parser = this.mDependencies.getJsonCommandFactory().createParser();
            CListOfAttributes attributes = parser.parse(json);
            List all = attributes.getAll();
            for (CAttributeEntry e : all) {
                CWidgetId widgetId = e.getWidgetId();
                String key = e.getKey();
                Object value = e.getValue();
                CServerWidget widget = this.mWidgets.get(widgetId);
                if (widget == null) {
                    this.mWidgetApi.applyWidgetNotification(widgetId, key, value);
                    continue;
                }
                this.applyWidgetNotification(widgetId, key, value, widget);
            }
        }
    }

    private void applyWidgetNotification(CWidgetId aWidgetId, String aKey, Object aValue, CServerWidget aWidget) {
        try {
            aWidget.applyNotification(aKey, aValue);
        }
        catch (Exception aE) {
            LOG.error((Throwable)aE, "Error applying notification {} to {}", new Object[]{aKey, aWidgetId});
        }
    }

    public CMessageBox createMessageBox(@NotNull CWidgetSetId aWidgetSetId, @NotNull String aName) {
        CMessageBox mb = new CMessageBox(aWidgetSetId, aName);
        this.addWidget(mb);
        CEventCreateWidget event = new CEventCreateWidget(EWidgetTypes.MessageBox.name(), mb.getWidgetId(), null, null);
        Object jo = event.toJson();
        this.mSender.addAttribute(CModelConstants.CONTEXT_WIDGET_ID, "createwidget", jo);
        return mb;
    }

    public void deactivate() throws Exception {
        this.stopContext(null);
        this.mWidgetApi.deactivate();
    }

    public void unmountWidget(@NotNull CWidgetId aWidgetId) {
        if (aWidgetId.isValid()) {
            CEventUnmountWidget ev = new CEventUnmountWidget(aWidgetId, 0);
            Object jo = ev.toJson();
            this.mSender.addAttribute(CModelConstants.CONTEXT_WIDGET_ID, "unmount", jo);
        }
    }

    public void startContext(@NotNull IId aContextId, @NotNull CNodeAddress aNode, @NotNull String aPlatformType, @Nullable IRemoteSkinServerContextListener aListener) throws CException {
        this.mDependencies.getRemoteSkinConnector().startContext(aContextId, aNode, aPlatformType, (aEntry, aResultCode, aResultText) -> {
            Object object = this.mClientContext = aResultCode == 0 ? aEntry : null;
            if (aListener != null) {
                aListener.notify(aEntry, aResultCode, aResultText);
            }
        });
    }

    public void stopContext(@Nullable IRemoteSkinServerContextListener aListener) throws CException {
        if (this.mClientContext != null) {
            this.mDependencies.getRemoteSkinConnector().stopContext(this.mClientContext.getId(), (aEntry, aResultCode, aResultText) -> {
                this.mClientContext = null;
                if (aListener != null) {
                    aListener.notify(aEntry, aResultCode, aResultText);
                }
            });
        }
    }

    public void pushWidgetSets(@NotNull List<String> aJson, @Nullable IRemoteSkinServerContextListener aListener) throws CException {
        if (this.mClientContext != null) {
            this.mDependencies.getRemoteSkinConnector().pushWidgetSets(this.mClientContext.getId(), aJson, aListener);
        }
    }

    public void mountWidgetSet(@NotNull CWidgetSetId aWidgetSetId, @Nullable CWidgetId aParent, @Nullable String aWidgetNameToShow, @Nullable IWidgetSetMountedListener aListener) {
        CTargetAddress address = this.mSenderTarget == null ? this.getAddress() : this.mSenderTarget.getAddress();
        UUID transactionId = aListener == null ? null : CUtilUuid.random();
        CEventMountWidgetSet event = new CEventMountWidgetSet(aWidgetSetId, address, aParent, aWidgetNameToShow, transactionId);
        if (transactionId != null) {
            this.mWidgetApi.addListener(transactionId, (IListener)aListener);
        }
        Object jo = event.toJson();
        this.mSender.addAttribute(CModelConstants.CONTEXT_WIDGET_ID, "mount", jo);
    }

    public void sendGlobalProperties(@NotNull String aJson) {
        CEventGlobalProperties event = new CEventGlobalProperties(aJson);
        Object jo = event.toJson();
        this.mSender.addAttribute(CModelConstants.CONTEXT_WIDGET_ID, "globalproperties", jo);
    }

    @Nullable
    public IRemoteSkinClientContext getClientContext() {
        return this.mClientContext;
    }

    @NotNull
    public IWidgetApi getWidgetApi() {
        return this.mWidgetApi;
    }
}

