/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.context;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventCaretNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxEditorNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventDouble;
import de.sillysky.nyssr.remoteskin.model.events.CEventExpansionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventLocalDateTime;
import de.sillysky.nyssr.remoteskin.model.events.CEventMenuNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventMouseNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventOnEnterNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventOnTableCellNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventPasswordNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventPopupNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventStringChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetSetMountedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventColorChooserDialogNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventFileChooserDialogNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventInputDialogAnswer;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventMessageDialogNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventSelectDialogNotification;
import de.sillysky.nyssr.remoteskin.server.events.CEventKeyNotification;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ICaretListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IColorChooserListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IComboBoxEditListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IComboBoxSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IDoubleListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IExpansionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IFileChooserListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IInputDialogListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IIntegerListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IKeyPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IKeyReleasedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IKeyTypedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ILocalDateTimeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IMenuChosenListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IMessageDialogListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IMouseListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IOnEnterListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IPasswordListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IPopupListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IStringChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IStringSelectDialogListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITableChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITableSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITreeChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITreeSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWidgetSetMountedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowActivatedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowDeactivatedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowDeiconifiedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowIconifiedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowOpenedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowStateChangedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CRemoteSkinServerListenerList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinServerListenerList.class);
    private final Map<CWidgetId, Set<IListener>> mMap = new HashMap<CWidgetId, Set<IListener>>();
    private final Map<UUID, IListener> mTransactionListeners = new HashMap<UUID, IListener>();

    CRemoteSkinServerListenerList() {
    }

    @Nullable
    Collection<IListener> get(@NotNull CWidgetId aWidgetId) {
        return this.mMap.get(aWidgetId);
    }

    void add(@NotNull CWidgetId aWidgetId, @NotNull IListener aListener) {
        Set set = this.mMap.computeIfAbsent(aWidgetId, k -> new HashSet());
        set.add(aListener);
    }

    void add(@NotNull CWidgetSetId aWidgetSetId, @NotNull String aWidgetName, @NotNull IListener aListener) {
        CWidgetId id = CWidgetId.create((String)aWidgetName, (CWidgetSetId)aWidgetSetId);
        Set set = this.mMap.computeIfAbsent(id, k -> new HashSet());
        set.add(aListener);
    }

    void add(@NotNull UUID aTransactionId, @NotNull IListener aListener) {
        this.mTransactionListeners.put(aTransactionId, aListener);
    }

    @NotNull
    private <T extends IListener> List<T> getListeners(@NotNull CWidgetId aWidgetId, @NotNull Class<T> aClass) {
        ArrayList<IListener> list = new ArrayList<IListener>();
        Set<IListener> listeners1 = this.mMap.get(aWidgetId);
        if (listeners1 != null && !listeners1.isEmpty()) {
            for (IListener l : listeners1) {
                if (!aClass.isAssignableFrom(l.getClass())) continue;
                list.add(l);
            }
        }
        return list;
    }

    void applyNotification(@NotNull CWidgetId aWidgetId, @NotNull String aKey, @NotNull Object aValue) throws Throwable {
        switch (aKey) {
            case "widgetUnmounted": 
            case "widgetSetLoaded": {
                break;
            }
            case "widgetSetMounted": {
                IWidgetSetMountedListener l;
                UUID transactionId;
                CEventWidgetSetMountedNotification event = CEventWidgetSetMountedNotification.create((Object)aValue);
                if (event == null || (transactionId = event.getTransactionId()) == null || (l = (IWidgetSetMountedListener)this.mTransactionListeners.get(transactionId)) == null) break;
                l.notify(event.getWidgetSetId());
                break;
            }
            case "onWindowActivated": {
                CEventWindowNotification event = CEventWindowNotification.create((Object)aValue);
                if (event == null) break;
                List<IWindowActivatedListener> listeners = this.getListeners(aWidgetId, IWindowActivatedListener.class);
                for (IWindowActivatedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onWindowClosed": {
                CEventWindowNotification event = CEventWindowNotification.create((Object)aValue);
                if (event == null) break;
                List<IWindowClosedListener> listeners = this.getListeners(aWidgetId, IWindowClosedListener.class);
                for (IWindowClosedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onWindowClosing": {
                CEventWindowNotification event = CEventWindowNotification.create((Object)aValue);
                if (event == null) break;
                List<IWindowClosingListener> listeners = this.getListeners(aWidgetId, IWindowClosingListener.class);
                for (IWindowClosingListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onWindowDeactivated": {
                CEventWindowNotification event = CEventWindowNotification.create((Object)aValue);
                if (event == null) break;
                List<IWindowDeactivatedListener> listeners = this.getListeners(aWidgetId, IWindowDeactivatedListener.class);
                for (IWindowDeactivatedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onWindowDeIconified": {
                CEventWindowNotification event = CEventWindowNotification.create((Object)aValue);
                if (event == null) break;
                List<IWindowDeiconifiedListener> listeners = this.getListeners(aWidgetId, IWindowDeiconifiedListener.class);
                for (IWindowDeiconifiedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onWindowIconified": {
                CEventWindowNotification event = CEventWindowNotification.create((Object)aValue);
                if (event == null) break;
                List<IWindowIconifiedListener> listeners = this.getListeners(aWidgetId, IWindowIconifiedListener.class);
                for (IWindowIconifiedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onWindowOpened": {
                CEventWindowNotification event = CEventWindowNotification.create((Object)aValue);
                if (event == null) break;
                List<IWindowOpenedListener> listeners = this.getListeners(aWidgetId, IWindowOpenedListener.class);
                for (IWindowOpenedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onWindowStateChanged": {
                CEventWindowNotification event = CEventWindowNotification.create((Object)aValue);
                if (event == null) break;
                List<IWindowStateChangedListener> listeners = this.getListeners(aWidgetId, IWindowStateChangedListener.class);
                for (IWindowStateChangedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onMouseClick": 
            case "onMouseDoubleClick": 
            case "onMouseEnter": 
            case "onMouseExit": 
            case "onMousePress": 
            case "onMouseRelease": {
                CEventMouseNotification ev = CEventMouseNotification.create((Object)aValue);
                if (ev == null) break;
                List<IMouseListener> listeners = this.getListeners(aWidgetId, IMouseListener.class);
                for (IMouseListener l : listeners) {
                    l.notify(ev);
                }
                break;
            }
            case "onkeytyped": {
                CEventKeyNotification event = new CEventKeyNotification(aValue);
                List<IKeyTypedListener> listeners = this.getListeners(aWidgetId, IKeyTypedListener.class);
                for (IKeyTypedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onkeypressed": {
                CEventKeyNotification event = new CEventKeyNotification(aValue);
                List<IKeyPressedListener> listeners = this.getListeners(aWidgetId, IKeyPressedListener.class);
                for (IKeyPressedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onkeyreleased": {
                CEventKeyNotification event = new CEventKeyNotification(aValue);
                List<IKeyReleasedListener> listeners = this.getListeners(aWidgetId, IKeyReleasedListener.class);
                for (IKeyReleasedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "answerSelectDialog": {
                CEventSelectDialogNotification event = CEventSelectDialogNotification.create((Object)aValue);
                if (event == null) break;
                List<IStringSelectDialogListener> listeners = this.getListeners(aWidgetId, IStringSelectDialogListener.class);
                for (IStringSelectDialogListener l : listeners) {
                    l.notify(event.getSelectedValue());
                }
                break;
            }
            case "answerInputDialog": {
                CEventInputDialogAnswer event = CEventInputDialogAnswer.create((Object)aValue);
                if (event == null) break;
                List<IInputDialogListener> listeners = this.getListeners(aWidgetId, IInputDialogListener.class);
                for (IInputDialogListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "answerMsgDialog": {
                CEventMessageDialogNotification event = CEventMessageDialogNotification.create((Object)aValue);
                if (event == null) break;
                List<IMessageDialogListener> listeners = this.getListeners(aWidgetId, IMessageDialogListener.class);
                for (IMessageDialogListener l : listeners) {
                    l.notify(event.getResult());
                }
                break;
            }
            case "onListSelect": {
                CEventListSelectionNotification event = CEventListSelectionNotification.create((Object)aValue);
                if (event == null) break;
                List<IListSelectionListener> listeners = this.getListeners(aWidgetId, IListSelectionListener.class);
                for (IListSelectionListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onComboSelect": {
                CEventComboBoxSelectionNotification event = CEventComboBoxSelectionNotification.create((Object)aValue);
                if (event == null) break;
                List<IComboBoxSelectionListener> listeners = this.getListeners(aWidgetId, IComboBoxSelectionListener.class);
                for (IComboBoxSelectionListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onComboEdit": {
                CEventComboBoxEditorNotification event = CEventComboBoxEditorNotification.create((Object)aValue);
                if (event == null) break;
                List<IComboBoxEditListener> listeners = this.getListeners(aWidgetId, IComboBoxEditListener.class);
                for (IComboBoxEditListener l : listeners) {
                    l.notifyEdit(event);
                }
                break;
            }
            case "onTreeSelect": {
                CEventTreeSelectionNotification event = CEventTreeSelectionNotification.create((Object)aValue);
                if (event == null) break;
                List<ITreeSelectionListener> listeners = this.getListeners(aWidgetId, ITreeSelectionListener.class);
                for (ITreeSelectionListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onButtonPressed": {
                CEventButtonPressedNotification event = CEventButtonPressedNotification.create((Object)aValue);
                if (event == null) break;
                List<IButtonPressedListener> listeners = this.getListeners(aWidgetId, IButtonPressedListener.class);
                for (IButtonPressedListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onSliderChange": {
                CEventInteger event = CEventInteger.create((Object)aValue);
                if (event == null) break;
                List<IIntegerListener> listeners = this.getListeners(aWidgetId, IIntegerListener.class);
                for (IIntegerListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onChangeDate": {
                CEventLocalDateTime event = CEventLocalDateTime.create((Object)aValue);
                if (event == null) break;
                List<ILocalDateTimeListener> listeners = this.getListeners(aWidgetId, ILocalDateTimeListener.class);
                for (ILocalDateTimeListener l : listeners) {
                    try {
                        l.notify(event);
                    }
                    catch (CException cException) {}
                }
                break;
            }
            case "onTextChange": {
                CEventTextChangeNotification event = CEventTextChangeNotification.create((Object)aValue);
                if (event == null) break;
                List<ITextChangeListener> listeners = this.getListeners(aWidgetId, ITextChangeListener.class);
                for (ITextChangeListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onChangeInt": {
                CEventInteger event = CEventInteger.create((Object)aValue);
                if (event == null) break;
                List<IIntegerListener> listeners = this.getListeners(aWidgetId, IIntegerListener.class);
                for (IIntegerListener l : listeners) {
                    try {
                        l.notify(event);
                    }
                    catch (CException cException) {}
                }
                break;
            }
            case "onChangeDouble": {
                CEventDouble event = CEventDouble.create((Object)aValue);
                if (event == null) break;
                List<IDoubleListener> listeners = this.getListeners(aWidgetId, IDoubleListener.class);
                for (IDoubleListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onChangeString": {
                CEventStringChangeNotification event = CEventStringChangeNotification.create((Object)aValue);
                if (event == null) break;
                List<IStringChangeListener> listeners = this.getListeners(aWidgetId, IStringChangeListener.class);
                for (IStringChangeListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onPopup": {
                CEventPopupNotification event = CEventPopupNotification.create((Object)aValue);
                if (event == null) break;
                List<IPopupListener> listeners = this.getListeners(aWidgetId, IPopupListener.class);
                for (IPopupListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onMenuChosen": {
                CEventMenuNotification event = CEventMenuNotification.create((Object)aValue);
                if (event == null) break;
                List<IMenuChosenListener> listeners = this.getListeners(aWidgetId, IMenuChosenListener.class);
                for (IMenuChosenListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onTableChange": {
                CEventOnTableCellNotification event = CEventOnTableCellNotification.create((Object)aValue);
                if (event == null) break;
                List<ITableChangeListener> listeners = this.getListeners(aWidgetId, ITableChangeListener.class);
                for (ITableChangeListener l : listeners) {
                    l.notify(event);
                }
                break;
            }
            case "onTableSelection": {
                CEventTableSelectionNotification ev = CEventTableSelectionNotification.create((Object)aValue);
                if (ev == null) break;
                List<ITableSelectionListener> listeners = this.getListeners(aWidgetId, ITableSelectionListener.class);
                for (ITableSelectionListener l : listeners) {
                    l.notify(ev);
                }
                break;
            }
            case "onExpansion": {
                CEventExpansionNotification ev = CEventExpansionNotification.create((Object)aValue);
                if (ev == null) break;
                List<IExpansionListener> listeners = this.getListeners(aWidgetId, IExpansionListener.class);
                for (IExpansionListener l : listeners) {
                    l.notify(ev);
                }
                break;
            }
            case "onTreeChange": {
                CEventTreeChangeNotification ev = CEventTreeChangeNotification.create((Object)aValue);
                if (ev == null) break;
                List<ITreeChangeListener> listeners = this.getListeners(aWidgetId, ITreeChangeListener.class);
                for (ITreeChangeListener l : listeners) {
                    l.notify(ev);
                }
                break;
            }
            case "onCaretChange": {
                CEventCaretNotification ev = CEventCaretNotification.create((Object)aValue);
                if (ev == null) break;
                List<ICaretListener> listeners = this.getListeners(aWidgetId, ICaretListener.class);
                for (ICaretListener l : listeners) {
                    l.notify(ev);
                }
                break;
            }
            case "onEnter": {
                CEventOnEnterNotification ev = CEventOnEnterNotification.create((Object)aValue);
                if (ev == null) break;
                List<IOnEnterListener> listeners = this.getListeners(aWidgetId, IOnEnterListener.class);
                for (IOnEnterListener l : listeners) {
                    l.notify(ev);
                }
                break;
            }
            case "onColorChooser": {
                CEventColorChooserDialogNotification ev = CEventColorChooserDialogNotification.create((Object)aValue);
                if (ev == null) break;
                List<IColorChooserListener> listeners = this.getListeners(aWidgetId, IColorChooserListener.class);
                for (IColorChooserListener l : listeners) {
                    l.notify(ev);
                }
                break;
            }
            case "fileChooserDialogNotification": {
                CEventFileChooserDialogNotification ev = CEventFileChooserDialogNotification.create((Object)aValue);
                if (ev == null) break;
                List<IFileChooserListener> listeners = this.getListeners(aWidgetId, IFileChooserListener.class);
                for (IFileChooserListener l : listeners) {
                    l.notify(ev);
                }
                break;
            }
            case "password": {
                CEventPasswordNotification ev = CEventPasswordNotification.create((Object)aValue);
                if (ev == null) break;
                List<IPasswordListener> listeners = this.getListeners(aWidgetId, IPasswordListener.class);
                for (IPasswordListener l : listeners) {
                    l.notify(ev);
                }
                break;
            }
            default: {
                LOG.warn("Notification not caught: {}", new Object[]{aKey});
            }
        }
    }

    public void deactivate() {
        this.mMap.clear();
        this.mTransactionListeners.clear();
    }
}

