/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.widget.parser.raw;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.remoteskin.widget.parser.raw.CWidgetEntry;
import de.sillysky.nyssr.impl.remoteskin.widget.parser.raw.CWidgetEntryList;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.arguments.CArgumentList;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.widget.parser.IWidgetEntry;
import de.sillysky.nyssr.widget.parser.IWidgetEntryList;
import java.util.UUID;

public class CUtilHierarchyParser {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilHierarchyParser.class);

    private CUtilHierarchyParser() {
    }

    public static void parse(CWidgetEntryList aEntryList, CJsonObject aJsonObject, String aName) throws CException {
        for (String parentId : aJsonObject.keys()) {
            Object value = aJsonObject.getValue(parentId);
            if (!(value instanceof CJsonArray)) continue;
            IWidgetEntry widget = aEntryList.find(parentId);
            if (widget == null) {
                widget = new CWidgetEntry(parentId, "?");
                aEntryList.add(widget);
            }
            CUtilHierarchyParser.parseSingle(aEntryList, widget, (CJsonArray)value);
        }
        LOG.info("Okay: Success: {} parsed.", new Object[]{aName});
    }

    private static void parseSingle(IWidgetEntryList aEntryList, IWidgetEntry aParent, CJsonArray aJSONArray) throws CException {
        int index = 0;
        for (Object o : aJSONArray.getChildren()) {
            if (o instanceof String) {
                IWidgetEntry entry;
                CArgumentList args = new CArgumentList().setDelimiter(",").toLower().split(o);
                String id = args.getString(0, "#");
                if ("#".equals(id)) {
                    id = UUID.randomUUID().toString();
                }
                if ((entry = aEntryList.find(id)) == null) {
                    CJsonObject entryAttributes = new CJsonObject(true);
                    CStringProperties attr = args.parseProperties(1, "=");
                    String widgetType = attr.getNormalized("widgetType");
                    if (CUtilString.isEmpty((String)widgetType)) {
                        throw new CException(19).append("Missing widgetType on Object ").append(o.toString());
                    }
                    if (CUtilNormalize.equals((String)EWidgetTypes.PlaceHolder.name(), (String)widgetType)) {
                        entry = new CWidgetEntry(id, widgetType);
                        entry.getProperties().addAll(attr);
                        entry.getProperties().put("placeholderid", id);
                        String instanceId = attr.getNormalized("instanceid", "");
                        entry.setPlaceHolderId(id, instanceId);
                    } else {
                        entry = new CWidgetEntry(id, widgetType);
                        for (String key : attr.getKeys()) {
                            entryAttributes.put(key, (Object)attr.get(key));
                        }
                    }
                    entry.setWidgetIndex(index);
                    entryAttributes.put("id", (Object)id);
                    entryAttributes.put("widgetType", (Object)widgetType);
                    entry.setAttributes(entryAttributes);
                    aEntryList.add(entry);
                } else {
                    entry.setWidgetIndex(index);
                }
                aParent.addChild(entry);
            }
            ++index;
        }
    }
}

