/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.client.node.ui.main;

import de.sillysky.nyssr.impl.client.node.ui.CAppEntry;
import de.sillysky.nyssr.impl.client.node.ui.CUtilUi;
import de.sillysky.nyssr.impl.client.node.ui.INodeClient;
import de.sillysky.nyssr.impl.client.node.ui.main.CAppListBox;
import de.sillysky.nyssr.util.swing.CUtilSwing;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class CFrameAppChooser
extends JFrame {
    private static final long serialVersionUID = -5551019331594516514L;
    private final Map<KeyStroke, Action> actionMap = new HashMap<KeyStroke, Action>();
    private CAppListBox mListBox;
    private final INodeClient mNodeClient;
    private final List<CAppEntry> mApps;

    public CFrameAppChooser(@NotNull INodeClient aNodeClient, @NotNull List<CAppEntry> aApps) {
        super("silly sky");
        this.mNodeClient = aNodeClient;
        this.mApps = aApps;
        this.init();
        this.setupKeys();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        CUtilUi.setImage(this);
        this.setSize(800, 500);
        Container contentPane = this.getContentPane();
        contentPane.setBackground(CNamedColors.get((String)"Sienna").getColor(255));
        this.mListBox = new CAppListBox();
        JScrollPane scroll = new JScrollPane(this.mListBox);
        contentPane.add(scroll);
        this.addMouseListener();
        this.addListAction();
        DefaultListModel<CAppEntry> listModel = new DefaultListModel<CAppEntry>();
        boolean i = false;
        for (CAppEntry e : this.mApps) {
            listModel.add(0, e);
        }
        this.mListBox.setModel(listModel);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
    }

    private void addMouseListener() {
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CAppEntry selectedItem;
                if (e.getClickCount() == 2 && (selectedItem = (CAppEntry)CFrameAppChooser.this.mListBox.getSelectedValue()) != null) {
                    CFrameAppChooser.this.mNodeClient.startApp(selectedItem);
                }
            }
        };
        this.mListBox.addMouseListener(mouseListener);
    }

    private void addListAction() {
        this.mListBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                CAppEntry selectedItem;
                if (e.getKeyCode() == 10 && (selectedItem = (CAppEntry)CFrameAppChooser.this.mListBox.getSelectedValue()) != null) {
                    CFrameAppChooser.this.mNodeClient.startApp(selectedItem);
                }
            }
        });
    }

    public void setupKeys() {
        KeyStroke key1 = KeyStroke.getKeyStroke(123, 0);
        AbstractAction showDialog = new AbstractAction("showDialog"){
            private static final long serialVersionUID = -4246817212497841846L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CFrameAppChooser.this.setState(CFrameAppChooser.this.getState() == 1 ? 0 : 1);
            }
        };
        this.actionMap.put(key1, showDialog);
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(e -> {
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            if (this.actionMap.containsKey(keyStroke)) {
                Action a = this.actionMap.get(keyStroke);
                ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), null);
                CUtilSwing.executeInUiThread(() -> a.actionPerformed(ae));
                return true;
            }
            return false;
        });
    }
}

