/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.dialog.monitor;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.remoteskin.dialog.monitor.CDialogEntry;
import de.sillysky.nyssr.impl.remoteskin.dialog.monitor.CDialogEntryComparator;
import de.sillysky.nyssr.impl.remoteskin.dialog.monitor.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.dialog.monitor.CConstantsDialogMonitor;
import de.sillysky.nyssr.remoteskin.dialog.monitor.records.CRecordNotifyDialogClosed;
import de.sillysky.nyssr.remoteskin.dialog.monitor.records.CRecordNotifyDialogOpened;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

class CDialogMonitor
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDialogMonitor.class);
    private static final String DUMP = "list dialogs";
    private static final String HELP_DUMP = "List all registered dialogs";
    private final IDependencies mDependencies;
    private final Map<UUID, CDialogEntry> mDialogs = new HashMap<UUID, CDialogEntry>();
    private IId mMicroServiceId;

    CDialogMonitor(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNotifyDialogOpened.ID, this::asyncNotifyDialogOpened);
        this.addMessageHandler(CRecordNotifyDialogClosed.ID, this::asyncNotifyDialogClosed);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncCliHandle);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.readPreferences();
        this.registerMicroService();
        this.registerCCommandLineHandler();
        return true;
    }

    private boolean asyncNotifyDialogOpened(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID id = CRecordNotifyDialogOpened.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)id, (String)"Dialog ID missing.", (Object[])new Object[0]);
        String dialogType = CRecordNotifyDialogOpened.getDialogType((CRecord)aRecord, (String)"");
        CTargetAddress clientContextAddress = CRecordNotifyDialogOpened.getClientContextAddress((CRecord)aRecord, null);
        CDialogEntry entry = new CDialogEntry(id, dialogType, aEnvelope.getSender(), clientContextAddress);
        this.mDialogs.put(id, entry);
        LOG.debug("Dialog {} ({}) added in node {}", new Object[]{id, entry.getDescription(), entry.getAddress().getNodeId()});
        return true;
    }

    private boolean asyncNotifyDialogClosed(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID id = CRecordNotifyDialogClosed.getId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)id, (String)"Dialog ID missing.", (Object[])new Object[0]);
        CDialogEntry removed = this.mDialogs.remove(id);
        if (removed == null) {
            LOG.debug("No dialog {} found.", new Object[]{id});
        } else {
            LOG.debug("Dialog {} ({}) dismissed from node {}", new Object[]{id, removed.getDescription(), removed.getAddress().getNodeId()});
        }
        return true;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.MONITOR, "Monitor");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private void registerCCommandLineHandler() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliAddHandler.create();
        CRecordCliAddHandler.setCommand((CRecord)record, (String[])new String[]{DUMP});
        CRecordCliAddHandler.setHelp((CRecord)record, (String[])new String[]{HELP_DUMP});
        this.sendNotification(env, record);
    }

    private boolean asyncCliHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String command = CRecordCliHandle.getCommand((CRecord)aRecord, (String)"");
        if (DUMP.equals(command)) {
            String[] args = CRecordCliHandle.getArguments((CRecord)aRecord, null);
            if (args != null && args.length == 1 && args[0] != null) {
                this.dump(args[0]);
            } else {
                this.dump("");
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void dump(@NotNull String aSearchString) {
        if (this.mDialogs.isEmpty()) {
            System.out.println("No dialogs running");
        } else {
            String search = aSearchString.toLowerCase();
            TreeSet<CDialogEntry> dialogsSortedForStartTime = new TreeSet<CDialogEntry>(new CDialogEntryComparator());
            for (CDialogEntry cDialogEntry : this.mDialogs.values()) {
                if (!cDialogEntry.match(search)) continue;
                dialogsSortedForStartTime.add(cDialogEntry);
            }
            if (dialogsSortedForStartTime.isEmpty()) {
                System.out.println("No dialogs found for search string (" + aSearchString + ")");
            } else {
                StringBuilder sb = new StringBuilder(5000);
                sb.append(CUtilString.LINE_CRLF);
                for (CDialogEntry value : dialogsSortedForStartTime) {
                    sb.append(value.toString());
                    sb.append(CUtilString.CRLF);
                }
                sb.append(CUtilString.LINE_CRLF);
                String string = sb.toString();
                System.out.println(string);
            }
        }
    }

    private void readPreferences() {
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("dialogMonitor");
        String s = preferences.get("microservice.instance.id", CNodeId.getLocal().toString());
        this.mMicroServiceId = CIdFactory.fromObject((Object)s);
    }

    private void registerMicroService() throws CException {
        ArrayList<CDescriptionOfRecord> nanos = new ArrayList<CDescriptionOfRecord>();
        nanos.add(new CDescriptionOfRecord(CRecordNotifyDialogOpened.ID, "Register Dialog"));
        nanos.add(new CDescriptionOfRecord(CRecordNotifyDialogClosed.ID, "Unregister Dialog"));
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(CConstantsDialogMonitor.MICRO_SERVICE_ID, "Dialog Monitor", nanos, this.mMicroServiceId, this.getAddress());
    }

    public void notifyTargetWillBeRemoved() throws Exception {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        super.notifyTargetWillBeRemoved();
    }
}

