/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.app.chooseapp;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.app.chooseapp.C00200ChooseApp;
import de.sillysky.nyssr.impl.web.app.chooseapp.CApplicationContext;
import de.sillysky.nyssr.impl.web.app.chooseapp.IDependencies;
import de.sillysky.nyssr.impl.web.app.chooseapp.ILocalAppContext;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordShowWebDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebNotifyDialogDismissed;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.web.dialog.login.CConstants;
import de.sillysky.nyssr.web.dialog.login.records.CRecordShowWebLoginDialog;
import de.sillysky.nyssr.web.dialog.login.records.CRecordWebLoginFinished;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CApp
extends CTarget
implements ILocalAppContext {
    private static final ILogger LOG = CLoggerFactory.getLogger(CApp.class);
    private static final IId MICRO_SERVICE_CURRENT_USER = CIdFactory.fromObject((Object)"NY_WebDialogCurrentUser_00315");
    private static final IId MICRO_SERVICE_LOGIN = CConstants.MICRO_SERVICE_ID;
    private static final String MAIN_WIDGET_ID = "rs_3a8b7318-0bb3-485b-af85-b527d2043882";
    private static final String ID_CURRENT_USER = "id_current_user";
    private final IDependencies mDependencies;
    private CApplicationContext mApplicationContext;
    private byte[] mSessionToken;
    private C00200ChooseApp mMainDialog;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private final Map<IId, CTargetAddress> mRunningMicroServices = new HashMap<IId, CTargetAddress>(10);

    CApp(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordShowWebLoginDialog.ID, this::asyncShowWebLoginDialog);
        this.addMessageHandler(CRecordWebLoginFinished.ID, this::asyncWebLoginFinished);
        this.addMessageHandler(CRecordShowWebDialog.ID, this::asyncShowWebDialog);
        this.addMessageHandler(CRecordWebNotifyDialogDismissed.ID, this::asyncWebDialogFinished);
    }

    void deactivate() throws CException {
        this.mWebApi.deregisterWidgetOwner();
    }

    @Override
    @NotNull
    public CApplicationContext getApplicationContext() {
        return this.mApplicationContext;
    }

    @Override
    @NotNull
    public IDependencies getDependencies() {
        return this.mDependencies;
    }

    @Override
    public byte[] getSessionToken() {
        return this.mSessionToken;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.info("Web App ChooseApp started.");
        CTargetAddress remoteSkinClient = this.mApplicationContext.getClientRemoteSkinAddress();
        this.mWebApi = new CWebApi((ITarget)this, remoteSkinClient);
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, remoteSkinClient);
        INamespace ns = this.mApplicationContext.getNamespace();
        if (ns != null) {
            this.mWebApi.registerWidgets(new String[]{CUtilUuid.random().toString()});
            this.mSessionToken = this.mApplicationContext.getSessionToken();
            if (this.mSessionToken == null) {
                this.sendShowLoginDialog();
            } else {
                this.openDialogCurrentUser();
                this.mMainDialog = new C00200ChooseApp(this, MAIN_WIDGET_ID);
                this.getTargetRegistry().registerTarget((ITarget)this.mMainDialog);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncShowWebLoginDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                CTargetAddress address = CRecordShowWebLoginDialog.getDialogTargetAddress((CRecord)aRecord, null);
                this.mRunningMicroServices.put(MICRO_SERVICE_LOGIN, address);
            }
            return true;
        }
        return false;
    }

    private boolean asyncShowWebDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 5108) {
                this.finish();
            } else if (resultCode == 0) {
                CTargetAddress address = CRecordShowWebDialog.getDialogTargetAddress((CRecord)aRecord, null);
                IId microServiceId = aEnvelope.getMicroServiceId();
                this.mRunningMicroServices.put(microServiceId, address);
            }
            aEnvelope.setResultSuccess();
            return true;
        }
        return false;
    }

    private boolean asyncWebLoginFinished(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        int reason = CRecordWebLoginFinished.getReason((CRecord)aRecord, (int)1);
        if (reason == 0) {
            this.mSessionToken = aEnvelope.getSessionToken();
            if (this.mSessionToken != null) {
                this.openDialogCurrentUser();
            }
            this.mMainDialog = new C00200ChooseApp(this, MAIN_WIDGET_ID);
            this.getTargetRegistry().registerTarget((ITarget)this.mMainDialog);
        }
        this.mRunningMicroServices.remove(MICRO_SERVICE_LOGIN);
        return true;
    }

    private boolean asyncWebDialogFinished(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId microserviceId = CRecordWebNotifyDialogDismissed.getMicroserviceId((CRecord)aRecord, null);
        this.mRunningMicroServices.remove(microserviceId);
        if (MICRO_SERVICE_CURRENT_USER.equals((Object)microserviceId)) {
            if (this.mMainDialog != null) {
                this.mMainDialog.deactivate();
                this.mMainDialog = null;
            }
            this.sendShowLoginDialog();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    @NotNull
    CTargetAddress start(@NotNull CApplicationContext aContext) throws Exception {
        this.mApplicationContext = aContext;
        INamespace namespace = this.mApplicationContext.getNamespace();
        CUtilCheck.checkNotNull((Object)namespace, (String)"Namespace missing", (Object[])new Object[0]);
        return namespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    private void openDialogCurrentUser() throws CException {
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_CURRENT_USER, this.mSessionToken, ID_CURRENT_USER, null);
    }

    private void sendShowLoginDialog() throws CException {
        CEnvelope envelope = CEnvelope.forMicroService((IId)MICRO_SERVICE_LOGIN);
        CRecord record = CRecordShowWebLoginDialog.create();
        CRecordShowWebLoginDialog.setClientTargetAddress((CRecord)record, (CTargetAddress)this.mApplicationContext.getClientRemoteSkinAddress());
        CRecordShowWebLoginDialog.setOwnerTargetAddress((CRecord)record, (CTargetAddress)this.getAddress());
        CRecordShowWebLoginDialog.setParentWidgetId((CRecord)record, (String)MAIN_WIDGET_ID);
        this.sendRequest(envelope, record);
    }

    private void finish() throws CException {
        for (CTargetAddress address : this.mRunningMicroServices.values()) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
            CRecord record = CRecordWebDismissDialog.create();
            this.sendNotification(env, record);
        }
        this.sendShowLoginDialog();
    }
}

