/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.gatekeeper;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.gatekeeper.IGateKeeper;
import de.sillysky.nyssr.gatekeeper.IGateKeeperRule;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.network.gatekeeper.CGateKeeperRule;
import de.sillysky.nyssr.impl.network.gatekeeper.CRuleList;
import de.sillysky.nyssr.impl.network.gatekeeper.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.broadcast.records.CRecordBroadcastTransportMsg;
import de.sillysky.nyssr.network.nodeinfo.records.CRecordGetNodeInfo;
import de.sillysky.nyssr.network.records.CRecordNetworkRouterPing;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetNodeRecord;
import de.sillysky.nyssr.network.router.records.CRecordNetworkRenewNodeRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CGateKeeper
implements IGateKeeper,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CGateKeeper.class);
    private static final String KEY = "rule";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final int COL_NUMBER = 6;
    private static final int COL_PLUS_MINUS = 0;
    private static final int COL_GATE = 1;
    private static final int COL_RECORD_ID = 2;
    private static final int COL_RECEIVER_NID = 3;
    private static final int COL_SENDER_NODE_ID = 4;
    private static final int COL_DESCRIPTION = 5;
    private static final IId[] GOOD_MID = new IId[]{CRecordGetNodeInfo.ID, CRecordNetworkGetNodeRecord.ID, CRecordNetworkRenewNodeRecord.ID, CRecordBroadcastTransportMsg.ID, CRecordNetworkRouterPing.ID};
    private final CRuleList mRuleList = new CRuleList();
    private final IDependencies mDependencies;

    CGateKeeper(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws BackingStoreException {
        LOG.debug("Activate {}", new Object[]{this.getClass().getSimpleName()});
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("network/gatekeeper");
        for (String k : preferences.keys()) {
            String key = k.toLowerCase();
            if (!key.startsWith(KEY)) continue;
            String value = preferences.get(k, "");
            String[] tt = value.split(",");
            if (tt.length == 6) {
                boolean plus;
                String token = tt[0].trim();
                if (PLUS.equals(token)) {
                    plus = true;
                } else {
                    if (!MINUS.equals(token)) continue;
                    plus = false;
                }
                int gate = 0;
                token = tt[1].trim();
                if (!token.isEmpty()) {
                    try {
                        gate = Integer.parseInt(token);
                    }
                    catch (NumberFormatException e1) {
                        continue;
                    }
                }
                token = tt[2].trim();
                IId recordID = null;
                if (!token.isEmpty()) {
                    recordID = CIdFactory.fromObject((Object)token);
                }
                token = tt[3].trim();
                IId nid = null;
                if (!token.isEmpty()) {
                    nid = CIdFactory.fromObject((Object)token);
                }
                token = tt[4].trim();
                CNodeId nodeId = null;
                if (!token.isEmpty()) {
                    nodeId = CNodeId.fromObject((Object)token);
                }
                token = tt[5].trim();
                this.addRule(plus, gate, recordID, nid, nodeId, token);
                continue;
            }
            LOG.warn("GateKeeper rule has 6 arguments separated by colon: + or -, gate, record id, receiver nid, sender node id, description");
        }
        aServiceRegistry.registerService(IGateKeeper.class, (Object)this);
        LOG.debug("GateKeeper has {} rules", new Object[]{this.mRuleList.size()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRule(IGateKeeperRule aRule) {
        CRuleList cRuleList = this.mRuleList;
        synchronized (cRuleList) {
            this.mRuleList.add(aRule);
        }
    }

    public void addRule(boolean aAllow, int aGate, IId aRecordID, IId aReceiverNID, CNodeId aSenderNodeId, String aDescription) {
        CGateKeeperRule r = new CGateKeeperRule(aAllow, aGate, aRecordID, aReceiverNID, aSenderNodeId, aDescription);
        this.addRule(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CResult checkMessage(int aGate, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CResult result = null;
        CTargetAddress sender = aEnvelope.getSender();
        CTargetAddress receiver = aEnvelope.getReceiver();
        IId mid = aRecord.getId();
        boolean okay = false;
        for (IId id : GOOD_MID) {
            if (!id.equals((Object)mid)) continue;
            okay = true;
            break;
        }
        if (!okay) {
            CRuleList cRuleList = this.mRuleList;
            synchronized (cRuleList) {
                if (this.mRuleList.match(aGate, mid, receiver.getNID(), sender.getNodeId())) {
                    okay = true;
                }
            }
        }
        String string = this.mDependencies.getNameDb().getRecordIdDatabase().getName(mid);
        if (!okay) {
            LOG.info("- Gate={}, ID={}, sender={}, receiver={}", new Object[]{aGate, string, sender, receiver});
        } else {
            LOG.debug("+ Gate={}, ID={}, sender={}, receiver={}", new Object[]{aGate, string, sender, receiver});
        }
        if (!okay) {
            result = new CResult(5306, "Rejected by GateKeeper");
        }
        return result;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    @NotNull
    public Collection<IGateKeeperRule> getRules() {
        CRuleList cRuleList = this.mRuleList;
        synchronized (cRuleList) {
            return this.mRuleList.getRules();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IGateKeeperRule removeRule(@NotNull String aDescription) {
        CRuleList cRuleList = this.mRuleList;
        synchronized (cRuleList) {
            return this.mRuleList.removeRule(aDescription);
        }
    }
}

